package com.xebialabs.deployit.engine.api;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.api.dto.Control;

/**
 * Provides access to control methods defined on CIs.
 */
@Path("/control")
@Consumes(MediaType.APPLICATION_XML)
@Produces(MediaType.APPLICATION_XML)
public interface ControlService {

    /**
     * Returns a parameter object for the task that will execute the control task method. The returned object can be used in the call to
     * <code>/control</code>.
     *
     * @permission controltask#execute
     * @param controlName The name of the control method to execute.
     * @param id the CI to execute the control method on
     * @return a Control parameter object.
     */
    @GET
    @Path("prepare/{controlName}/{id:.*?}")
    Control prepare(@PathParam("controlName") String controlName, @PathParam("id") String id);

    /**
     * Creates the control task.
     *
     * @permission controltask#execute
     * @param control the Control parameter object, created by invoking <code>/control/prepare</code>.
     * @return a reference to a Task ID that can be executed by the {@link TaskService}.
     */
    @POST
    String createTask(Control control);

}
