package com.xebialabs.deployit.engine.api;

import java.util.List;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.security.Permission;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;

/**
 * Provides Deployit's metadata: available types, permissions and orchestrators.
 */
@Path("/metadata")
@Consumes({MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_XML})
public interface MetadataService {

    /**
     * Lists all the {@link Descriptor Descriptors} of all the types known to the Deployit Type System.
     * Hidden properties are not exposed.
     *
     * @return A List of {@link Descriptor Descriptors}
     */
    @GET
    @Path("type")
    List<Descriptor> listDescriptors();

    /**
     * Gets the {@link Descriptor} for a specific type from the Deployit Type System.
     *
     * @param type the type to get the descriptor of.
     * @return The descriptor matching the type
     */
    @GET
    @Path("type/{type}")
    Descriptor findDescriptor(@PathParam("type") Type type);

    /**
     * Lists all the {@link Permission Permissions} that can be granted or revoked.
     *
     * @return A List of {@link Permission Permissions}
     */
    @GET
    @Path("permissions")
    List<Permission> listPermissions();

    /**
     * Lists all the Orchestrator names that can be used to orchestrate a {@link Deployment} done by the {@link DeploymentService}.
     *
     * @return A List of orchestrator names.
     */
    @GET
    @Path("orchestrators")
    List<String> listOrchestrators();
}
