package com.xebialabs.deployit.engine.api.security;

import java.util.Iterator;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.xebialabs.deployit.engine.api.dto.AbstractDto;

@XmlRootElement
public class Role extends AbstractDto {

    private Integer id = -1;

    private String name;

    public Role() {
    }

    public Role(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    // Don't add a Role(String) constructor, since RestEasy will pick it up when it's there when it should
    // use valueOf(String)

    public static Role forName(String name) {
        return new Role(-1, name);
    }

    @XmlAttribute
    public Integer getId() {
        return id;
    }

    @XmlAttribute
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public static Role valueOf(String roleString) {
        Iterator<String> split = Splitter.on(":").split(roleString).iterator();
        return new Role(Integer.valueOf(split.next()), split.next());
    }

    @Override
    public String toString() {
        return Joiner.on(":").join(id, name);
    }
}
