package com.xebialabs.deployit.engine.api.dto;

import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.google.common.collect.Lists.newArrayList;

public class Deployment extends AbstractDto {
    public enum DeploymentType { INITIAL, UPDATE, UNDEPLOYMENT }

    private ConfigurationItem deployedApplication;

    private List<ConfigurationItem> deployeds = newArrayList();

    private List<ConfigurationItemId> deployables = newArrayList();

    private List<ConfigurationItemId> containers = newArrayList();

    private DeploymentType deploymentType;

    public ConfigurationItem getDeployedApplication() {
        return deployedApplication;
    }

    public List<ConfigurationItem> getDeployeds() {
        return deployeds;
    }

    public DeploymentType getDeploymentType() {
        return deploymentType;
    }

    public void setDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public boolean isOfType(DeploymentType type) {
        return this.deploymentType == type;
    }

    public void setDeployedApplication(ConfigurationItem deployedApplication) {
        this.deployedApplication = deployedApplication;
    }

    public void setDeployeds(List<ConfigurationItem> deployeds) {
        this.deployeds = deployeds;
    }

    public void add(ConfigurationItem object) {
        this.deployeds.add(object);
    }

    public void addAll(List<ConfigurationItem> deployeds) {
        this.deployeds.addAll(deployeds);
    }

    public String getVersion() {
        return (String) deployedApplication.getProperty("version");
    }

    public String getEnvironment() {
        return (String) deployedApplication.getProperty("environment");
    }

    public List<ConfigurationItemId> getDeployables() {
        return deployables;
    }

    public void setDeployables(List<ConfigurationItemId> deployables) {
        this.deployables = deployables;
    }

    public List<ConfigurationItemId> getContainers() {
        return containers;
    }

    public void setContainers(List<ConfigurationItemId> containers) {
        this.containers = containers;
    }
}
