package com.xebialabs.deployit.engine.api.xml;

import org.jboss.resteasy.annotations.Decorator;
import org.jboss.resteasy.spi.interception.DecoratorProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import java.lang.annotation.*;

/**
 * Ensures that the XML Preamble is removed from the response, this facilitates certain broken Rest clients
 * which need a wrapped XML response.
 */
@Retention(RetentionPolicy.RUNTIME)
@Decorator(processor = OmitXmlPreamble.Processor.class, target = Marshaller.class)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
@Inherited
public @interface OmitXmlPreamble {

    /**
     * Needs object as generic type, to prevent RESTEASY-701 from appearing.
     */
    public static class Processor implements DecoratorProcessor<Object, OmitXmlPreamble> {
        @Override
        public Object decorate(Object target, OmitXmlPreamble annotation, @SuppressWarnings("rawtypes") Class type, Annotation[] annotations, MediaType mediaType) {
            if (!(target instanceof Marshaller)) return target;
            try {
                ((Marshaller) target).setProperty(Marshaller.JAXB_FRAGMENT, true);
                logger.trace("Omitting XML Preamble");
                return target;
            } catch (PropertyException ignored) {
                return target;
            }
        }
        private static final Logger logger = LoggerFactory.getLogger(OmitXmlPreamble.Processor.class);
    }
}
