/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.server.api.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import javax.jcr.Node;
import java.util.List;

public interface RawRepository {

    void renameType(String oldTypeName, String newTypeName);

    Node read(String id);

    /**
     * Create a new empty node at the specific id, make sure its parents exist
     * @param id the id for the new Node
     * @return the created JCR Node
     */
    Node create(String id);

    void delete(String id);

    List<Node> findNodesByType(Type type);
}
