/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.artifact.resolution;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

/**
 * The ResolvedArtifactFile is created by the {@link com.xebialabs.deployit.engine.spi.artifact.resolution.ArtifactResolver}
 * and represents the (possibly remote) artifact file. The contents of which will be copied to an XL-* application server when they're
 * necessary during for instance a deployment.
 */
public interface ResolvedArtifactFile extends Closeable {

    /**
     * The filename of the file that this ResolvedArtifactFile represents.
     *
     * @return the filename
     */
    String getFileName();

    /**
     * Opens a new {@link java.io.InputStream} containing the data of the resolved file.
     *
     * @return an {@link java.io.InputStream}
     *
     * @throws java.io.IOException When there was an error opening the {@link java.io.InputStream}
     */
    InputStream openStream() throws IOException;

    /**
     * Allows for cleanup of any resources that were needed in order to create this ResolvedArtifactFile.
     * (Also see: {@link java.io.Closeable#close()}
     * <p/>
     * This method will always be called by the application in order to ensure no resources are leaked.
     */
    void close() throws IOException;
    /**
     * Returns the file size in bytes if known, or -1 if the size cannot be determined.
     *
     * @return the file size in bytes, or -1L if unknown
     */
    default long getFileSize() {
        return -1L; // -1 indicates unknown size
    }
}
