package com.xebialabs.deployit.engine.spi.event;


public class UserPasswordChangedEvent extends AuditableDeployitEvent {

    private final String username;
    
    public UserPasswordChangedEvent(String username) {
        super("security", String.format("Changed password for user %s", format(username)));
        this.username = username;
    }

    public String getUsername() {
        return username;
    }
}
