package com.xebialabs.deployit.engine.spi.event;


public class RoleRenamedEvent extends AuditableDeployitEvent {

    private final String roleName;
    private final String newName;
    
    public RoleRenamedEvent(String roleName, String newName) {
        super("security", String.format("Renamed role %s to %s", format(roleName), format(newName)));
        this.roleName = roleName;
        this.newName = newName;
    }

    public String getRoleName() {
        return roleName;
    }

    public String getNewName() {
        return newName;
    }
}
