package com.xebialabs.deployit.engine.spi.event;

import java.util.List;

import com.google.common.base.Joiner;

public class RolePrincipalsChangedEvent extends AuditableDeployitEvent {

    private final List<String> newPrincipals;

    public RolePrincipalsChangedEvent(List<String> newPrincipals) {
        super("security", String.format("Updated role principals:\n") + Joiner.on("\n").join(newPrincipals));
        this.newPrincipals = newPrincipals;
    }

    public List<String> getNewPrincipals() {
        return newPrincipals;
    }

}
