package com.xebialabs.deployit.engine.spi.exception;

import java.util.Collection;
import java.util.List;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

import static java.lang.String.format;

@SuppressWarnings("serial")
@HttpResponseCodeResult
public class DeployitException extends RuntimeException {

    private final List<String> errors;
    private Object entity;

    public DeployitException() {
        errors = Lists.newArrayList();
    }

    public DeployitException(String message) {
        errors = Lists.newArrayList();
        errors.add(message);
    }

    public DeployitException(final String messageTemplate, final Object... params) {
        errors = Lists.newArrayList(format(messageTemplate, params));
    }

    public DeployitException(final Throwable cause, final String messageTemplate, final Object... params) {
        super(cause);
        errors = Lists.newArrayList(format(messageTemplate, params));
    }

    public DeployitException(final Throwable cause) {
        super(cause);
        errors = Lists.newArrayList();
    }

    public DeployitException(Object entity) {
        this.entity = entity;
        errors = Lists.newArrayList();
    }
    
    public void add(String messageTemplate, final Object... params) {
        errors.add(format(messageTemplate, params));
    }

    public void addAll(Collection<String> messages) {
        errors.addAll(messages);
    }

    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    public List<String> getErrors() {
        return errors;
    }

    @Override
    public String getMessage() {
        return Joiner.on("\n").join(errors);
    }

    public boolean hasEntity() {
        return entity != null;
    }
    
    public Object getEntity() {
        return entity;
    }
}
