<#function oddEven index>
    <#if (index % 2) == 0>
        <#return "even" />
    <#else>
        <#return "odd" />
    </#if>
</#function>

<#function yesNo required>
    <#if required>
        <#return "Yes" />
    <#else>
        <#return "No" />
    </#if>
</#function>

<div class="ci-reference">
    <h2 class="ci-toc-category">Step Reference</h2>
<#list steps?sort_by("name") as step>
    <h3 class="ci-toc-category">${step.name}</h3>
    ${step.htmlDescription}
    <h4 class="ci-toc-category">Step Parameters</h4>
    <table class="ci-toc">
        <tr class="odd ci-toc-header">
            <th>Parameter</th>
            <th>Type</th>
            <th>Description</th>
            <th>Required</th>
            <th>Calculated</th>
        </tr>
        <#list step.parameters?sort_by("name") as parameter>
            <tr class="${oddEven(parameter_index)}">
                <td>${parameter.name}</td>
                <td>${parameter.type}</td>
                <td>${parameter.description}</td>
                <td>${yesNo(parameter.required)}</td>
                <td>${yesNo(parameter.calculated)}</td>
            </tr>
        </#list>
    </table>
    <strong>Note:</strong> For information about how values are calcuated, please refer to <a href="rulesmanual.html#calculated-step-parameters">Calculated step parameters</a> in the Rules Manual.
</#list>
</div>
