package com.xebialabs.deployit.documentation;

import com.google.common.collect.ForwardingMap;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;

public class ContextProperties extends ForwardingMap<String, String> {

    private Map<String, String> delegate = newHashMap();

    public ContextProperties() {
    }

    public ContextProperties(Map<String, String> delegate) {
        this.delegate = delegate;
    }

    public ContextProperties getRootContext() {
        Map<String, String> map = newHashMap();
        for (String key : delegate.keySet()) {
            if (key.indexOf('.') == -1) {
                map.put(key, delegate.get(key));
            }
        }
        return new ContextProperties(map);
    }

    public ContextProperties getContext(String context) {
        String prefix = context + ".";
        Map<String, String> map = newHashMap();
        for (String key : delegate.keySet()) {
            if (key.startsWith(prefix)) {
                map.put(key.substring(prefix.length()), delegate.get(key));
            }
        }
        return new ContextProperties(map);
    }

    @Override
    protected Map<String, String> delegate() {
        return delegate;
    }

    public String get(String key, String defaultValue) {
        if (delegate.containsKey(key)) {
            return delegate.get(key);
        }
        return defaultValue;
    }
}
