/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.documentation.CiReferenceHtmlWriter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiReferenceGenerator {
    private List<String> prefixes;
    private List<Descriptor> cis;
    private CiReferenceHtmlWriter doc;
    private static final Logger logger;

    public CiReferenceGenerator(List<String> prefixes, CiReferenceHtmlWriter writer) {
        this.prefixes = prefixes;
        this.cis = this.findDescriptors();
        this.doc = writer;
        this.doc.setCis(this.cis);
    }

    public void generateCiReference() {
        logger.info("Generating documentation for " + (!this.prefixes.isEmpty() ? "CIs with prefix '" + this.prefixes + "'" : "all CIs"));
        this.doc.startCiReference();
        this.ciSummary();
        this.ciDetails();
        this.doc.endCiReference();
    }

    public void generateDocument() {
        this.doc.startDocument();
        this.generateCiReference();
        this.doc.endDocument();
    }

    private void ciSummary() {
        this.doc.tocHeader();
        this.tableOfContents(Collections2.filter(this.cis, (Predicate)CiPredicates.DEPLOYABLE), "Deployables");
        this.tableOfContents(Collections2.filter(this.cis, (Predicate)CiPredicates.DEPLOYED), "Deployeds");
        this.tableOfContents(Collections2.filter(this.cis, (Predicate)CiPredicates.CONTAINER), "Containers");
        this.tableOfContents(Collections2.filter(this.cis, CiPredicates.otherCIs()), "Other Configuration Items");
    }

    private void ciDetails() {
        this.doc.detailsHeader();
        for (Descriptor ci : this.cis) {
            this.doc.ciDetailTitle(ci.getType());
            this.doc.ciTypeInfo(ci);
            this.doc.ciDescription(ci.getDescription());
            Collection<PropertyDescriptor> properties = CiReferenceGenerator.sortProperties(ci.getPropertyDescriptors());
            this.doc.ciProperties(Collections2.filter(properties, (Predicate)PropertyPredicates.PARENT), "Parent");
            this.doc.ciProperties(Collections2.filter(properties, (Predicate)PropertyPredicates.CHILDREN), "Children");
            this.doc.ciProperties(Collections2.filter(properties, (Predicate)PropertyPredicates.PUBLIC), "Public Properties");
            this.doc.ciProperties(Collections2.filter(properties, (Predicate)PropertyPredicates.HIDDEN), "Hidden Properties");
            Collection<MethodDescriptor> methods = CiReferenceGenerator.sortMethods(ci.getControlTasks());
            this.controlTasks(methods, "Control Tasks");
            this.doc.detailsSeparator();
        }
    }

    private void controlTasks(Collection<MethodDescriptor> methods, String category) {
        if (methods.isEmpty()) {
            return;
        }
        this.doc.startControlTask(category);
        int row = 0;
        for (MethodDescriptor method : methods) {
            this.doc.controlTaskMethod(method, row);
            ++row;
        }
        this.doc.endControlTask();
    }

    private void tableOfContents(Collection<Descriptor> cis, String category) {
        if (cis.isEmpty()) {
            return;
        }
        this.doc.categoryHeader(category);
        this.doc.startToc();
        int row = 0;
        for (Descriptor ci : cis) {
            this.doc.tocEntry(ci, CiReferenceGenerator.extractFirstSentence(ci.getDescription()), row);
            ++row;
        }
        this.doc.endToc();
    }

    private static String extractFirstSentence(String text) {
        if (text == null) {
            return "";
        }
        if (text.indexOf(".") > -1) {
            return text.substring(0, text.indexOf("."));
        }
        return text;
    }

    private List<Descriptor> findDescriptors() {
        Collection filtered = Collections2.filter((Collection)DescriptorRegistry.getDescriptors(), (Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return input.getDescription() != null && CiReferenceGenerator.this.shouldInclude(input.getType());
            }
        });
        ArrayList needsRefDoc = Lists.newArrayList((Iterable)filtered);
        Collections.sort(needsRefDoc, new Comparator<Descriptor>(){

            @Override
            public int compare(Descriptor o1, Descriptor o2) {
                return o1.getType().toString().compareTo(o2.getType().toString());
            }
        });
        logger.info("Found {} CI descriptors to generate documentation for.", (Object)needsRefDoc.size());
        return needsRefDoc;
    }

    private boolean shouldInclude(Type type) {
        return this.prefixes.isEmpty() || this.prefixes.contains(type.getPrefix());
    }

    private static Collection<PropertyDescriptor> sortProperties(Collection<PropertyDescriptor> properties) {
        ArrayList result = Lists.newArrayList(properties);
        Collections.sort(result, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                int result;
                int n = o1.isRequired() == o2.isRequired() ? 0 : (result = o1.isRequired() ? -1 : 1);
                if (result == 0) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }
        });
        return result;
    }

    private static Collection<MethodDescriptor> sortMethods(Collection<MethodDescriptor> methods) {
        ArrayList result = Lists.newArrayList(methods);
        Collections.sort(result, new Comparator<MethodDescriptor>(){

            @Override
            public int compare(MethodDescriptor o1, MethodDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    static {
        LocalBooter.bootWithoutGlobalContext();
        logger = LoggerFactory.getLogger(CiReferenceGenerator.class);
    }

    static enum PropertyPredicates implements Predicate<PropertyDescriptor>
    {
        PUBLIC{

            public boolean apply(PropertyDescriptor property) {
                return !property.isHidden() && !1.isParent(property) && !1.isChild(property);
            }
        }
        ,
        PARENT{

            public boolean apply(PropertyDescriptor property) {
                return 2.isParent(property) && !property.isHidden();
            }
        }
        ,
        CHILDREN{

            public boolean apply(PropertyDescriptor property) {
                return 3.isChild(property) && !property.isHidden();
            }
        }
        ,
        HIDDEN{

            public boolean apply(PropertyDescriptor property) {
                return property.isHidden();
            }
        };


        static boolean isParent(PropertyDescriptor ci) {
            return ci.isAsContainment() && ci.getKind() == PropertyKind.CI;
        }

        static boolean isChild(PropertyDescriptor ci) {
            return ci.isAsContainment() && ci.getKind() != PropertyKind.CI;
        }
    }

    static enum CiPredicates implements Predicate<Descriptor>
    {
        DEPLOYABLE{

            public boolean apply(Descriptor type) {
                return type.isAssignableTo(Deployable.class);
            }
        }
        ,
        DEPLOYED{

            public boolean apply(Descriptor type) {
                return type.isAssignableTo(Deployed.class);
            }
        }
        ,
        CONTAINER{

            public boolean apply(Descriptor type) {
                return type.isAssignableTo(Container.class);
            }
        };


        static Predicate<Descriptor> otherCIs() {
            return Predicates.not((Predicate)Predicates.or((Predicate[])CiPredicates.values()));
        }
    }
}

