/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream

import com.thoughtworks.xstream.converters.{Converter, MarshallingContext, UnmarshallingContext}
import com.thoughtworks.xstream.io.{HierarchicalStreamReader, HierarchicalStreamWriter}
import com.xebialabs.deployit.engine.api.dto.ActiveTaskStatus

@XStreamProvider(readable = classOf[ActiveTaskStatus], tagName = "activeTaskStatus")
class ActiveTaskStatusWriter extends Converter {
  override def marshal(source: Any, writer: HierarchicalStreamWriter, context: MarshallingContext): Unit = {
    val taskStatus = source.asInstanceOf[ActiveTaskStatus]
    writer.addAttribute("taskId", taskStatus.taskId)
    writer.addAttribute("path", taskStatus.path)
    writer.addAttribute("status", taskStatus.status)
  }

  override def unmarshal(reader: HierarchicalStreamReader, context: UnmarshallingContext): AnyRef = {
    val taskId = reader.getAttribute("taskId")
    val path = reader.getAttribute("path")
    val status = reader.getAttribute("status")
    new ActiveTaskStatus(taskId, path, status)
  }

  override def canConvert(`type`: Class[_]): Boolean = classOf[ActiveTaskStatus].isAssignableFrom(`type`)
}
