/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.*;

public class BlockStateJsonConverter extends JsonConverter<BlockState> {

    private boolean serialiseSteps;

    public BlockStateJsonConverter() {
        this(true);
    }

    public BlockStateJsonConverter(boolean serialiseSteps) {
        this.serialiseSteps = serialiseSteps;
    }

    public JsonWriter writeJsonObject(BlockState block, JsonWriter writer) {
        writer.object();
        writeBlockBasics(block, writer);

        if (block instanceof CompositeBlockState) {
            writeJsonCompositeBlockState((CompositeBlockState) block, writer);
        } else if (block instanceof StepBlockState) {
            writeJsonStepBlockState((StepBlockState) block, writer);
        } else if (block instanceof PhaseContainerState) {
            writeJsonPhaseContainer((PhaseContainerState) block, writer);
        }

        writer.endObject();

        return writer;
    }

    private void writeJsonPhaseContainer(PhaseContainerState phaseContainerState, JsonWriter writer) {
        writer.key("root").value("true");

        Iterable<PhaseState> blocks = phaseContainerState.getBlocks();
        if (blocks.iterator().hasNext()) {
            writer.key("blocks").array();
            for (PhaseState phase : blocks) {
                writePhase(phase, writer);
            }
            writer.endArray();
        }
    }

    public void writePhase(PhaseState phase, JsonWriter writer) {

        writer.object();
        writeBlockBasics(phase, writer);
        writer.key("phase").value("true");

        writer.key("block");
        writeJsonObject(phase.getBlock(), writer);

        writer.endObject();
    }

    public void writeBlockBasics(BlockState block, JsonWriter writer) {
        writer.key("id").value(block.getId() == null ? "" : block.getId());
        writer.key("state").value(block.getState() == null ? null : block.getState().toString());
        writer.key("description").value(block.getDescription());
    }

    private void writeJsonStepBlockState(StepBlockState block, JsonWriter writer) {
        writer.key("currentStep").value(block.getCurrentStep());

        if (serialiseSteps && block.getSteps() != null && !block.getSteps().isEmpty()) {
            StepStateJsonConverter stepStateJsonConverter = new StepStateJsonConverter();
            writer.key("steps").array();
            for (StepState stepState : block.getSteps()) {
                stepStateJsonConverter.writeJsonObject(stepState, writer);
            }
            writer.endArray();
        }
    }

    private void writeJsonCompositeBlockState(CompositeBlockState block, JsonWriter writer) {
        writer.key("parallel").value(block.isParallel());

        if (block.getBlocks() != null && !block.getBlocks().isEmpty()) {
            writer.key("blocks").array();
            for (BlockState blockChild : block.getBlocks()) {
                writeJsonObject(blockChild, writer);
            }
            writer.endArray();
        }
    }
}
