/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.dto.ImportFromUrlParams;
import org.apache.commons.lang.StringUtils;

import static com.xebialabs.xltype.serialization.xstream.Converters.writeNode;

@XStreamProvider(readable = ImportFromUrlParams.class, tagName = "url-params")
public class ImportFromUrlParamsConverter implements Converter {
    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ImportFromUrlParams params = (ImportFromUrlParams) source;
        writeNode("url", params.getUrl(), writer);
        if (!StringUtils.isBlank(params.getCredentialsId())) {
            writeNode("credentialsId", params.getCredentialsId(), writer);
        }
        writeNode("user", params.getUser(), writer);
        writeNode("password", params.getPassword(), writer);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ImportFromUrlParams params = new ImportFromUrlParams();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("url".equals(reader.getNodeName())) {
                params.setUrl(reader.getValue());
            }
            if ("credentialsId".equals(reader.getNodeName())) {
                params.setCredentialsId(reader.getValue());
            }
            if ("user".equals(reader.getNodeName())) {
                params.setUser(reader.getValue());
            }
            if ("password".equals(reader.getNodeName())) {
                params.setPassword(reader.getValue());
            }
        }
        return params;
    }

    @Override
    public boolean canConvert(Class type) {
        return ImportFromUrlParams.class.isAssignableFrom(type);
    }
}