/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.joda.time.DateTime;

import com.xebialabs.xltype.serialization.util.DateUtil;

public class DateTimeAdapter extends XmlAdapter<String, DateTime> {

    @Override
    public DateTime unmarshal(String v) {
        return DateUtil.fromString(v);
    }

    @Override
    public String marshal(DateTime v) {
        return DateUtil.toString(v);
    }
}
