/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.List;

@XStreamProvider(tagName="deployment", readable=Deployment.class)
public class DeploymentConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Deployment depl = (Deployment)source;
        if (depl.getId() != null) {
            writer.addAttribute("id", depl.getId());
        }
        writer.addAttribute("type", depl.getDeploymentType().name());
        writer.startNode("deploymentGroupIndex");
        writer.setValue(String.valueOf(depl.getDeploymentGroupIndex()));
        writer.endNode();
        writer.startNode("application");
        Converters.writeConfigurationItem(depl.getDeployedApplication(), writer, context);
        writer.endNode();
        writer.startNode("deployeds");
        for (ConfigurationItem configurationItem : depl.getDeployeds()) {
            Converters.writeConfigurationItem(configurationItem, writer, context);
        }
        writer.endNode();
        this.writeIds("deployables", depl.getDeployables(), writer, context);
        this.writeIds("containers", depl.getContainers(), writer, context);
        writer.startNode("resolvedPlaceholders");
        for (ResolvedPlaceholder placeholder : depl.getResolvedPlaceholders()) {
            writer.startNode("placeholder");
            writer.addAttribute("encrypted", String.valueOf(placeholder.isEncrypted()));
            writer.addAttribute("containerId", placeholder.containerId());
            writer.addAttribute("deployedAppId", placeholder.deployedAppId());
            writer.addAttribute("dictionaryId", placeholder.dictionaryId());
            writer.addAttribute("environmentId", placeholder.environmentId());
            writer.addAttribute("versionId", placeholder.versionId());
            writer.addAttribute("key", placeholder.key());
            writer.addAttribute("value", placeholder.value());
            writer.endNode();
        }
        writer.endNode();
        writer.startNode("requiredDeployments");
        for (Deployment d : depl.getRequiredDeployments()) {
            writer.startNode("deployment");
            context.convertAnother((Object)d);
            writer.endNode();
        }
        writer.endNode();
    }

    private void writeIds(String nodeName, List<ConfigurationItemId> ids, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.startNode(nodeName);
        for (ConfigurationItemId configurationItemId : ids) {
            this.writerConfigurationItemId(configurationItemId, writer, context);
        }
        writer.endNode();
    }

    private void writerConfigurationItemId(ConfigurationItemId configurationItemId, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.startNode("ci");
        context.convertAnother((Object)configurationItemId);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Deployment depl = new Deployment();
        depl.setId(reader.getAttribute("id"));
        depl.setDeploymentType(Deployment.DeploymentType.valueOf((String)reader.getAttribute("type")));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("application".equals(reader.getNodeName())) {
                reader.moveDown();
                ConfigurationItem ci = (ConfigurationItem)context.convertAnother((Object)depl, ConfigurationItem.class);
                depl.setDeployedApplication(ci);
                reader.moveUp();
            } else if ("deployeds".equals(reader.getNodeName())) {
                depl.setDeployeds(Converters.readList(depl, ConfigurationItem.class, reader, context));
            } else if ("deployables".equals(reader.getNodeName())) {
                depl.setDeployables(Converters.readList(depl, ConfigurationItemId.class, reader, context));
            } else if ("containers".equals(reader.getNodeName())) {
                depl.setContainers(Converters.readList(depl, ConfigurationItemId.class, reader, context));
            } else if ("requiredDeployments".equals(reader.getNodeName())) {
                depl.setRequiredDeployments(Converters.readList(depl, Deployment.class, reader, context));
            } else if ("deploymentGroupIndex".equals(reader.getNodeName())) {
                String value = reader.getValue();
                if (!value.isEmpty()) {
                    depl.setDeploymentGroupIndex(Integer.parseInt(value));
                }
            } else if ("resolvedPlaceholders".equals(reader.getNodeName())) {
                depl.addResolvedPlaceholders(Converters.readPlaceholders(reader));
            }
            reader.moveUp();
        }
        return depl;
    }

    public boolean canConvert(Class type) {
        return Deployment.class.isAssignableFrom(type);
    }
}

