/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DeploymentJsonConverter {
    private final ConfigurationItemConverter ciConverter;

    public DeploymentJsonConverter(ConfigurationItemConverter converter) {
        this.ciConverter = converter;
    }

    public ConfigurationItemConverter getCiConverter() {
        return this.ciConverter;
    }

    public String toJson(Deployment deployment) {
        JsonWriter writer = new JsonWriter();
        this.toJson(deployment, writer);
        return writer.toString();
    }

    public void toJson(Deployment deployment, JsonWriter writer) {
        CiJsonWriter ciWriter = new CiJsonWriter(writer);
        ConfigurationItemConverter converter = new ConfigurationItemConverter();
        writer.object();
        writer.key("type").value(deployment.getDeploymentType());
        writer.key("application");
        converter.writeCi(deployment.getDeployedApplication(), ciWriter);
        writer.key("deployeds");
        converter.writeCis(deployment.getDeployeds(), ciWriter);
        writer.key("deployables");
        ciWriter.typedCiReferences(deployment.getDeployables());
        writer.key("containers");
        ciWriter.typedCiReferences(deployment.getContainers());
        writer.endObject();
    }

    public Deployment toDeployment(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            return this.toDeployment(json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    public Deployment toDeployment(JSONObject json) throws JSONException {
        String jsonString = json.toString();
        Preconditions.checkArgument((boolean)json.has("type"), (String)"Missing 'type' property in JSON:\n%s", (Object[])new Object[]{jsonString});
        Preconditions.checkArgument((boolean)json.has("application"), (String)"Missing 'application' property in JSON:\n%s", (Object[])new Object[]{jsonString});
        Preconditions.checkArgument((boolean)json.has("deployeds"), (String)"Missing 'deployeds' property in JSON:\n%s", (Object[])new Object[]{jsonString});
        Deployment deployment = new Deployment();
        Deployment.DeploymentType type = Deployment.DeploymentType.valueOf((String)json.getString("type"));
        deployment.setDeploymentType(type);
        ConfigurationItemConverter converter = new ConfigurationItemConverter();
        ConfigurationItem application = converter.readCi(new CiJsonReader(json.getJSONObject("application")));
        deployment.setDeployedApplication(application);
        List<ConfigurationItem> deployeds = converter.readCis(new CiListJsonReader(json.getJSONArray("deployeds")));
        deployment.setDeployeds(deployeds);
        deployment.setDeployables(DeploymentJsonConverter.toConfigurationItemIds(json.getJSONArray("deployables")));
        deployment.setContainers(DeploymentJsonConverter.toConfigurationItemIds(json.getJSONArray("containers")));
        return deployment;
    }

    private static List<ConfigurationItemId> toConfigurationItemIds(JSONArray jsonArray) throws JSONException {
        ArrayList ids = Lists.newArrayList();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ids.add(DeploymentJsonConverter.toConfigurationItemId(jsonArray.getJSONObject(i)));
        }
        return ids;
    }

    private static ConfigurationItemId toConfigurationItemId(JSONObject jsonObject) throws JSONException {
        return new ConfigurationItemId(jsonObject.getString("ci"), Type.valueOf((String)jsonObject.getString("type")));
    }
}

