package com.xebialabs.deployit.booter.local.validation;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import org.apache.commons.lang.StringUtils;

public class IntegerOrPlaceholderValidator implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
    @Override
    public void validate(String value, ValidationContext context) {
        if (value == null)
            return;
        if (!(isPlaceholder(value) || isInteger(value))) {
            context.error("This value is not valid. The expected type is integer (num) or placeholder.", value);
        }
    }

    private boolean isPlaceholder(String value) {
        return StringUtils.startsWith(value, "{{") && StringUtils.endsWith(value, "}}");
    }

    private boolean isInteger(String value) {
        return StringUtils.isNumeric(value);
    }
}
