package com.xebialabs.deployit.booter.local;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import static com.xebialabs.deployit.booter.local.utils.Closeables.closeQuietly;
import static com.xebialabs.xlplatform.utils.ReflectionUtils$.MODULE$;
import static javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI;

class SyntheticHelper {
    static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = createDocumentBuilderFactory();

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
            Schema syntheticSchema = schemaFactory.newSchema(MODULE$.classLoader().getResource("synthetic.xsd"));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setSchema(syntheticSchema);
        } catch (SAXException exc) {
            throw new RuntimeException("Cannot read schema synthetic.xsd", exc);
        }
        return documentBuilderFactory;
    }

    static Document readSyntheticDocument(final URL syntheticXML) throws IOException {
        InputStream syntheticXMLStream = syntheticXML.openStream();
        try {
            final boolean validationErrorsFound[] = new boolean[1];
            DocumentBuilder builder = SyntheticHelper.DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler() {
                @Override
                public void warning(SAXParseException exc) throws SAXException {
                    logger.warn("Warning while parsing " + syntheticXML, exc);
                }

                @Override
                public void error(SAXParseException exc) throws SAXException {
                    logger.error("Error while parsing " + syntheticXML, exc);
                    validationErrorsFound[0] = true;
                }

                @Override
                public void fatalError(SAXParseException exc) throws SAXException {
                    logger.error("Fatal error while parsing " + syntheticXML, exc);
                    validationErrorsFound[0] = true;
                }
            });
            Document doc = builder.parse(syntheticXMLStream);
            if (validationErrorsFound[0]) {
                throw new RuntimeException("One or more errors were found while parsing " + syntheticXML);
            }

            return doc;
        } catch (RuntimeException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        } catch (ParserConfigurationException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        } catch (SAXException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        } finally {
            closeQuietly(syntheticXMLStream);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(SyntheticHelper.class);
}
