/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.xlplatform.utils.ReflectionUtils$;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginVersions {
    private static final Map<String, String> PLUGIN_VERSIONS = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(PluginVersions.class);

    static void init() {
        try {
            Enumeration<URL> resources = ReflectionUtils$.MODULE$.classLoader().getResources("plugin-version.properties");
            ArrayList urls = Lists.newArrayList((Iterator)Iterators.forEnumeration(resources));
            for (URL url : urls) {
                PluginVersions.readPluginVersion((InputSupplier<InputStream>)Resources.newInputStreamSupplier((URL)url));
            }
        }
        catch (IOException e) {
            logger.error("Couldn't read plugin-version.properties", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static String getVersionFor(String plugin) {
        return PLUGIN_VERSIONS.get(plugin);
    }

    public static Set<String> getRegisteredPlugins() {
        return PLUGIN_VERSIONS.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readPluginVersion(InputSupplier<InputStream> supplier) throws IOException {
        InputStream input = (InputStream)supplier.getInput();
        try {
            Properties properties = new Properties();
            properties.load(input);
            String plugin = properties.getProperty("plugin");
            String version = properties.getProperty("version");
            PLUGIN_VERSIONS.put(plugin, version);
        }
        finally {
            Closeables.closeQuietly(input);
        }
    }
}

