/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateRegistry {
    private static final Map<String, Method> DELEGATES = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(DelegateRegistry.class);

    static void boot() {
        logger.info("Registering delegates.");
        Set allDelegateMethods = Scannit.getInstance().getMethodsAnnotatedWith(Delegate.class);
        logger.debug("All classes with Delegate: {}", (Object)allDelegateMethods);
        HashSet<String> classes = new HashSet<String>();
        for (Method m : allDelegateMethods) {
            classes.add(m.getDeclaringClass().getName());
        }
        HashSet<Method> delegateMethods = new HashSet<Method>();
        for (Method m : allDelegateMethods) {
            String n = m.getDeclaringClass().getName();
            if (n.endsWith("$") && classes.contains(n.substring(0, n.length() - 1))) continue;
            delegateMethods.add(m);
        }
        for (Method delegateMethod : delegateMethods) {
            Delegate annotation = delegateMethod.getAnnotation(Delegate.class);
            Method put = DELEGATES.put(annotation.name(), delegateMethod);
            logger.debug("Registered delegate [{}] ({}).", (Object)annotation.name(), (Object)delegateMethod);
            if (put == null) continue;
            throw new IllegalStateException(String.format("Found 2 methods with same delegate name [%s]: %s and %s", annotation.name(), put, delegateMethod));
        }
    }

    static void verify(Verifications verifications) {
        for (Map.Entry<String, Method> entry : DELEGATES.entrySet()) {
            Method method = entry.getValue();
            String name = entry.getKey();
            verifications.verify(List.class.isAssignableFrom(method.getReturnType()), "Delegate [%s (%s)] should have a List<Step> return type", name, method);
            Object[] parameterTypes = method.getParameterTypes();
            verifications.verify(parameterTypes.length >= 3 && parameterTypes.length <= 4, "Delegate [%s (%s)] should take 3 or 4 arguments (Taking: %s)", name, method, Lists.newArrayList((Object[])parameterTypes));
            verifications.verify(ConfigurationItem.class.isAssignableFrom((Class<?>)parameterTypes[0]), "Delegate [%s (%s)] should take a ConfigurationItem as first parameter", name, method);
            verifications.verify(parameterTypes[1].equals(String.class), "Delegate [%s (%s)] should take a String as second parameter", name, method);
            verifications.verify(Map.class.isAssignableFrom((Class<?>)parameterTypes[2]), "Delegate [%s (%s)] should take a Map<String, String> as third parameter", name, method);
            if (parameterTypes.length == 4) {
                verifications.verify(Parameters.class.isAssignableFrom((Class<?>)parameterTypes[3]), "Delegate [%s (%s)] should take a ConfigurationItem as fourth parameter", name, method);
            }
            if (Modifier.isStatic(method.getModifiers())) continue;
            Class<?> declaringClass = method.getDeclaringClass();
            try {
                declaringClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                verifications.verify(false, "Delegate [%s (%s)] does not have a public no-arg constructor.", name, method);
            }
        }
    }

    static boolean exists(String name) {
        return DELEGATES.containsKey(name);
    }

    static Method getDelegate(String name) {
        return DELEGATES.get(name);
    }

    static Object instantiateDelegate(String name) {
        try {
            return DELEGATES.get(name).getDeclaringClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate delegate: " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not instantiate delegate: " + name, e);
        }
    }
}

