/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticHelper;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class TypeSystemBootstrapper {
    private static final Logger logger = LoggerFactory.getLogger(TypeSystemBootstrapper.class);

    TypeSystemBootstrapper() {
    }

    void bootstrap(TypeDefinitions typeDefs) {
        logger.info("Bootstrapping the XL Deploy Type System.");
        this.scanClasses(typeDefs);
        this.scanSynthetics(typeDefs);
        this.createTypeTree(typeDefs);
        this.registerTypeDefinitions(typeDefs);
    }

    private void createTypeTree(TypeDefinitions typeDefs) {
        for (TypeDefinitions.TypeDefinition typeDefinition : typeDefs.getDefinitions()) {
            typeDefinition.registerTypeTree();
        }
    }

    void verifyTypes(Verifications verifications) {
        for (Descriptor descriptor : FluentIterable.from((Iterable)DescriptorRegistry.getDescriptors()).filter((Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return !input.isVirtual();
            }
        })) {
            ((LocalDescriptor)descriptor).verify(verifications);
        }
    }

    private void scanClasses(TypeDefinitions typeDefs) {
        typeDefs.defineType(ConfigurationItem.class);
        Set cis = Scannit.getInstance().getSubTypesOf(ConfigurationItem.class);
        for (Class ci : cis) {
            typeDefs.defineType(ci);
        }
    }

    private void scanSynthetics(TypeDefinitions typeDefs) {
        try {
            ArrayList types = Lists.newArrayList();
            ArrayList typeModifications = Lists.newArrayList();
            this.readSynthetics("synthetic.xml", types, typeModifications);
            this.readSynthetics("synthetic-test.xml", types, typeModifications);
            this.parseAllTypeDefinitions(types, typeDefs);
            this.parseAllTypeModifications(typeDefs, typeModifications);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read synthetic type definitions.", ex);
        }
    }

    private void registerTypeDefinitions(TypeDefinitions typeDefs) {
        for (TypeDefinitions.TypeDefinition typeDefinition : typeDefs.getDefinitions()) {
            typeDefinition.register(typeDefs);
        }
    }

    private void parseAllTypeDefinitions(List<Element> types, TypeDefinitions typeDefs) {
        for (Element type : types) {
            typeDefs.defineType(type);
            Iterator<Element> generatedTypes = XmlUtils.childByName(type, (Predicate<String>)Predicates.equalTo((Object)"generate-deployable"));
            if (generatedTypes.hasNext()) {
                typeDefs.defineGeneratedType(generatedTypes.next(), type);
            }
            this.findAllGeneratedParameterTypes(typeDefs, type);
        }
    }

    private void findAllGeneratedParameterTypes(TypeDefinitions typeDefs, Element type) {
        Iterator<Element> methodDefs = XmlUtils.childByName(type, (Predicate<String>)Predicates.equalTo((Object)"method"));
        while (methodDefs.hasNext()) {
            Element methodDef = methodDefs.next();
            Iterator<Element> parameters = XmlUtils.childByName(methodDef, (Predicate<String>)Predicates.equalTo((Object)"parameters"));
            if (!parameters.hasNext()) continue;
            typeDefs.defineGeneratedParameterType(methodDef, type);
        }
    }

    private void parseAllTypeModifications(TypeDefinitions typeDefs, List<Element> typeModifications) {
        for (Element typeModification : typeModifications) {
            typeDefs.modifyType(typeModification);
            this.findAllGeneratedParameterTypes(typeDefs, typeModification);
        }
    }

    private void readSynthetics(String name, List<Element> typeDefinitionCollector, List<Element> typeModificationsCollector) throws IOException {
        Enumeration<URL> syntheticXMLs = ClassLoaderUtils$.MODULE$.classLoader().getResources(name);
        while (syntheticXMLs.hasMoreElements()) {
            URL syntheticXML = syntheticXMLs.nextElement();
            logger.debug("Scanning synthetic XML: {}", (Object)syntheticXML);
            Element docElement = SyntheticHelper.readSyntheticDocument(syntheticXML).getDocumentElement();
            Iterators.addAll(typeDefinitionCollector, XmlUtils.childByName(docElement, (Predicate<String>)Predicates.equalTo((Object)"type")));
            Iterators.addAll(typeModificationsCollector, XmlUtils.childByName(docElement, (Predicate<String>)Predicates.equalTo((Object)"type-modification")));
        }
    }
}

