/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.reflect.ConfigurationItemPostConstructor;
import com.xebialabs.deployit.plugin.api.reflect.Process;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.javadude.scannit.Scannit;

final class ConfigurationItemPostProcessors {
    private static final Multimap<Type, ConfigurationItemPostConstructor> processorsPerType = ArrayListMultimap.create();

    private ConfigurationItemPostProcessors() {
    }

    static void registerPostProcessors() {
        HashSet processors = new HashSet();
        Scannit scannit = Scannit.getInstance();
        processors.addAll(scannit.getTypesAnnotatedWith(Process.class));
        processors.retainAll(scannit.getSubTypesOf(ConfigurationItemPostConstructor.class));
        processors.stream().forEach(ConfigurationItemPostProcessors::registerPostProcessor);
    }

    static Set<ConfigurationItemPostConstructor> getProcessors(Type type) {
        List superTypes = type.getDescriptor().getSuperClasses();
        Set interfaces = type.getDescriptor().getInterfaces();
        return Stream.concat(Stream.concat(Stream.of(type), superTypes.stream()), interfaces.stream()).flatMap(t -> processorsPerType.get(t).stream()).collect(Collectors.toSet());
    }

    private static void registerPostProcessor(Class<?> postProcessorClass) {
        try {
            String type = postProcessorClass.getAnnotation(Process.class).type();
            processorsPerType.put((Object)Type.valueOf((String)type), (Object)((ConfigurationItemPostConstructor)postProcessorClass.newInstance()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

