/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.GlobalContext;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptorWithDifferentOwner;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.validation.CollectionTypeValidator;
import com.xebialabs.deployit.booter.local.validation.ReferenceCollectionTypeValidator;
import com.xebialabs.deployit.booter.local.validation.ReferenceTypeValidator;
import com.xebialabs.deployit.booter.local.validation.RequiredValidator;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalPropertyDescriptor
implements PropertyDescriptor {
    private static final Integer ZERO = 0;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LocalDescriptor declaringDescriptor;
    private String fullyQualifiedName;
    private String name;
    private boolean asContainment;
    private String category;
    private String description;
    private String label;
    private boolean password;
    private boolean required;
    private Property.Size size;
    private PropertyKind kind;
    private List<String> enumValues;
    private Class<?> enumClass;
    private Type referencedType;
    private boolean hidden;
    private boolean inspectionProperty;
    private boolean requiredForInspection;
    private boolean isTransient;
    protected Set<Validator<?>> validationRules = Sets.newHashSet();
    private Set<String> aliases = Sets.newHashSet();
    private String candidateValuesFilter;
    private boolean deployedSpecific;
    private boolean primitive;

    protected void reInitializeRequired() {
        if (this.kind == PropertyKind.BOOLEAN && this.required) {
            this.logger.warn("Required boolean property [{}] will be treated as an optional property.", (Object)this);
            this.required = false;
        }
        if ((this.kind == PropertyKind.LIST_OF_CI || this.kind == PropertyKind.SET_OF_CI) && this.asContainment && this.required) {
            this.logger.warn("Required asContainment collection of configuration items [{}] will be treated as an optional property.", (Object)this);
            this.required = false;
        }
    }

    LocalPropertyDescriptor copyWithNewDescriptor(LocalDescriptor declaringDescriptor) {
        return new LocalPropertyDescriptorWithDifferentOwner(this, declaringDescriptor);
    }

    protected void setFromPropertyDescriptor(LocalPropertyDescriptor pd) {
        this.setName(pd.getName());
        this.setAsContainment(pd.isAsContainment());
        this.setCategory(pd.getCategory());
        this.setDescription(pd.getDescription());
        this.setLabel(pd.getLabel());
        this.setPassword(pd.isPassword());
        this.setRequired(pd.isRequired());
        this.setSize(pd.getSize());
        this.setKind(pd.getKind());
        this.setEnumValues(pd.getEnumValues());
        this.setEnumClass(pd.getEnumClass());
        this.setReferencedType(pd.getReferencedType());
        this.setHidden(pd.isHidden());
        this.setInspectionProperty(pd.isInspectionProperty());
        this.setRequiredForInspection(pd.isRequiredForInspection());
        this.setValidationRules(Sets.newHashSet(pd.validationRules));
        this.setAliases(Sets.newHashSet(pd.getAliases()));
        this.setTransient(pd.isTransient());
        this.setCandidateValuesFilter(pd.getCandidateValuesFilter());
        this.setDeployedSpecific(pd.isDeployedSpecific());
    }

    public void verify(Verifications verifications) {
        this.verifyName(verifications, "name");
        this.verifyName(verifications, "displayName");
        this.verifyName(verifications, "id");
        this.verifyName(verifications, "type");
        verifications.verify(!this.getName().contains("$"), "Cannot define a property named '%s' because it contains a '$'", this.getName());
        verifications.verify(!this.hidden || this.isTransient, "Hidden property '%s' should be transient", this);
        boolean isCiKind = EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI, PropertyKind.CI).contains(this.kind);
        verifications.verify(!this.asContainment || isCiKind, "'%s' can only be an as containment relation if it is a 'set_of_ci', 'list_of_ci' or 'ci' kind property", this);
        verifications.verify(this.referencedType == null || isCiKind, "'%s' can only have reference type '%s' set when it is a (Set/List of) CI kind property", this, this.referencedType);
        verifications.verify(this.candidateValuesFilter == null || isCiKind, "'%s' can only define a candidate-values-filter if it is a 'set_of_ci', 'list_of_ci' or 'ci' kind property", this);
        verifications.verify(this.candidateValuesFilter == null || this.findFilterMethod() != null, "'%s' refers to an unknown candidate-values-filter '%s'", this, this.candidateValuesFilter);
        verifications.verify(!this.asContainment || isCiKind, "'%s' can only be an as containment relation if it is a 'set_of_ci', 'list_of_ci' or 'ci' kind property", this);
        verifications.verify(this.referencedType == null || isCiKind, "'%s' can only have reference type '%s' set when it is a (Set/List of) CI kind property", this, this.referencedType);
        boolean isPasswordKind = EnumSet.of(PropertyKind.STRING, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_STRING, PropertyKind.MAP_STRING_STRING).contains(this.kind);
        if (this.password && !isPasswordKind) {
            Deprecations.deprecated((String)"'%s' can only be a password property if it is a 'string', 'set_of_string', 'list_of_string' or 'map_string_string' kind property", (Object[])new Object[]{this});
        }
        this.verifyAliases(verifications);
    }

    private void verifyAliases(Verifications verifications) {
        if (!this.aliases.isEmpty()) {
            for (PropertyDescriptor otherPd : this.declaringDescriptor.getPropertyDescriptors()) {
                LocalPropertyDescriptor pd = (LocalPropertyDescriptor)otherPd;
                if (otherPd.equals(this)) continue;
                verifications.verify(this.declaringDescriptor.getType(), !this.aliases.contains(pd.getName()), "Aliases of [%s] contain name [%s] which is an existing property.", this, pd.getName());
                ImmutableSet intersection = Sets.intersection(this.aliases, pd.aliases).immutableCopy();
                verifications.verify(this.declaringDescriptor.getType(), intersection.isEmpty(), "Aliases of [%s] conflict with aliases of [%s]. Conflicting: %s", this, pd, intersection);
            }
        }
    }

    private void verifyName(Verifications verifications, String name) {
        verifications.verify(!this.name.equals(name), "Cannot define a property named '%s' on %s", name, this.declaringDescriptor);
    }

    private Method findFilterMethod() {
        Set filters = Scannit.getInstance().getMethodsAnnotatedWith(CandidateValuesFilter.class);
        return (Method)Iterables.tryFind((Iterable)filters, input -> input.getAnnotation(CandidateValuesFilter.class).name().equals(this.candidateValuesFilter)).orNull();
    }

    protected void initEnumValues(Class<?> enumClass) {
        this.enumValues = Lists.newArrayList();
        this.enumClass = enumClass;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            this.enumValues.add(enumValue.name());
        }
    }

    protected void addDefaultValidationRules() {
        if (this.required && !this.asContainment && this.kind != PropertyKind.BOOLEAN) {
            this.validationRules.add(new RequiredValidator());
        }
        if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_CI, PropertyKind.LIST_OF_STRING).contains(this.kind)) {
            this.validationRules.add(new CollectionTypeValidator(this));
        }
        if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(this.kind)) {
            this.validationRules.add(new ReferenceCollectionTypeValidator(this));
        } else if (PropertyKind.CI == this.kind) {
            this.validationRules.add(new ReferenceTypeValidator(this));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAsContainment() {
        return this.asContainment;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Property.Size getSize() {
        return this.size;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public List<String> getEnumValues() {
        return this.enumValues != null ? Lists.newArrayList(this.enumValues) : this.enumValues;
    }

    public Class<?> getEnumClass() {
        return this.enumClass;
    }

    public LocalDescriptor getDeclaringDescriptor() {
        return this.declaringDescriptor;
    }

    public Type getReferencedType() {
        return this.referencedType;
    }

    public Object getDefaultValue() {
        return this.convertValue(GlobalContext.lookup(this));
    }

    private Object convertValue(String val) {
        if (val == null) {
            return null;
        }
        switch (this.kind) {
            case BOOLEAN: {
                return Boolean.parseBoolean(val);
            }
            case INTEGER: {
                if (val.isEmpty()) {
                    return null;
                }
                return Integer.parseInt(val);
            }
            case STRING: {
                return val;
            }
            case ENUM: {
                if (this.enumClass != null) {
                    for (Enum enumConstant : (Enum[])this.enumClass.getEnumConstants()) {
                        if (!enumConstant.name().equalsIgnoreCase(val)) continue;
                        return enumConstant;
                    }
                    throw new IllegalArgumentException("Value " + val + " not a member of enum " + this.enumClass);
                }
                Optional optionalValue = Iterables.tryFind(this.enumValues, input -> input.equalsIgnoreCase(val));
                if (optionalValue.isPresent()) {
                    return optionalValue.get();
                }
                throw new IllegalArgumentException("Value " + val + " not a member of possible enum values");
            }
            case DATE: {
                return DatatypeConverter.parseDateTime((String)val).getTime();
            }
            case SET_OF_STRING: {
                return Sets.newLinkedHashSet(this.splitValue(val));
            }
            case LIST_OF_STRING: {
                return Lists.newArrayList(this.splitValue(val));
            }
            case MAP_STRING_STRING: {
                return this.decodeMap(val);
            }
        }
        throw new IllegalArgumentException("Property " + this.name + " of kind " + this.kind + " cannot be converted from a string value");
    }

    private Map<String, String> decodeMap(String val) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (String s : this.splitValue(val)) {
            String[] split = s.split(":");
            Preconditions.checkArgument((Strings.emptyToNull((String)split[0]) != null ? 1 : 0) != 0, (String)"Property %s of kind %s cannot be converted from string value '%s' because of any empty key.", (Object[])new Object[]{this.name, this.kind, val});
            if (split.length == 1) {
                map.put(split[0], "");
                continue;
            }
            map.put(split[0], split[1]);
        }
        return map;
    }

    private Iterable<String> splitValue(String val) {
        return Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)val);
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public String getCandidateValuesFilter() {
        return this.candidateValuesFilter;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public final void set(ConfigurationItem item, Object value) {
        if (value instanceof String) {
            value = this.convertValue((String)value);
        } else if (value == null) {
            value = this.getDefaultValue();
        }
        if (value == null) {
            value = this.emptyValue();
        }
        this.logger.trace("Setting value [{}] on property [{}] of CI [{}]", new Object[]{value, this.getFqn(), item.getId()});
        this.doSetValue(item, value);
    }

    protected abstract void doSetValue(ConfigurationItem var1, Object var2);

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.areEqual(item, other, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem item, ConfigurationItem other, Set<String> itemsBeingCompared) {
        Object left = this.get(item);
        Object right = this.get(other);
        this.logger.trace("Comparing {}: old [{}] <-> new [{}]", new Object[]{this.getFqn(), left, right});
        return this.areValuesEqual(left, right, itemsBeingCompared);
    }

    private boolean areValuesEqual(Object itemValue, Object otherValue, Set<String> itemsBeingCompared) {
        if (itemValue == null) {
            return otherValue == null;
        }
        if (otherValue == null) {
            return false;
        }
        switch (this.kind) {
            case SET_OF_STRING: {
                return this.symmetricDifference((Set)itemValue, (Set)otherValue).isEmpty();
            }
            case SET_OF_CI: {
                Function f = ConfigurationItem::getName;
                Iterable cis = Iterables.concat((Iterable)((Set)itemValue), (Iterable)((Set)otherValue));
                ImmutableListMultimap index = Multimaps.index((Iterable)cis, (Function)f);
                for (String key : index.keySet()) {
                    ConfigurationItem rhs;
                    Collection cisToCompare = index.get((Object)key);
                    if (cisToCompare.size() != 2) {
                        return false;
                    }
                    Iterator itemIterator = cisToCompare.iterator();
                    ConfigurationItem lhs = (ConfigurationItem)itemIterator.next();
                    if (this.areCiEqual(lhs, rhs = (ConfigurationItem)itemIterator.next(), itemsBeingCompared)) continue;
                    return false;
                }
                return true;
            }
            case CI: {
                ConfigurationItem itemValueAsCi = (ConfigurationItem)itemValue;
                ConfigurationItem otherValueAsCi = (ConfigurationItem)otherValue;
                if (itemValueAsCi.getName().equals(otherValueAsCi.getName())) {
                    LocalDescriptor descriptor = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)itemValueAsCi.getType());
                    return descriptor.areEqualDeeply(itemValueAsCi, otherValueAsCi, itemsBeingCompared);
                }
                return false;
            }
            case MAP_STRING_STRING: {
                Map left = (Map)itemValue;
                Map right = (Map)otherValue;
                return Maps.difference((Map)left, (Map)right).areEqual();
            }
            case LIST_OF_STRING: {
                List leftStrings = (List)itemValue;
                List rightStrings = (List)otherValue;
                return Iterables.elementsEqual((Iterable)leftStrings, (Iterable)rightStrings);
            }
            case LIST_OF_CI: {
                List lhs = (List)itemValue;
                List rhs = (List)otherValue;
                if (lhs.size() != rhs.size()) {
                    return false;
                }
                Iterator lIter = lhs.iterator();
                Iterator rIter = rhs.iterator();
                while (lIter.hasNext()) {
                    ConfigurationItem rItem;
                    ConfigurationItem lItem = (ConfigurationItem)lIter.next();
                    if (this.areCiEqual(lItem, rItem = (ConfigurationItem)rIter.next(), itemsBeingCompared)) continue;
                    return false;
                }
                return true;
            }
        }
        return itemValue.equals(otherValue);
    }

    private Set<String> symmetricDifference(Set<String> leftSet, Set<String> rightSet) {
        HashSet<String> symmetricDiff = new HashSet<String>(leftSet);
        symmetricDiff.addAll(rightSet);
        HashSet<String> tmp = new HashSet<String>(leftSet);
        tmp.retainAll(rightSet);
        symmetricDiff.removeAll(tmp);
        return symmetricDiff;
    }

    private boolean areCiEqual(ConfigurationItem lItem, ConfigurationItem rItem, Set<String> itemsBeingCompared) {
        LocalDescriptor descriptor;
        return lItem.getName().equals(rItem.getName()) && lItem.getType().equals((Object)rItem.getType()) && (descriptor = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)lItem.getType())).areEqualDeeply(lItem, rItem, itemsBeingCompared);
    }

    void validate(ConfigurationItem ci, List<ValidationMessage> messages) {
        ValidationContext context = (message, params) -> messages.add(new ValidationMessage(ci.getId(), this.name, String.format(message, params)));
        for (Validator<?> validationRule : this.validationRules) {
            validationRule.validate(this.get(ci), context);
        }
    }

    public boolean isInspectionProperty() {
        return this.inspectionProperty;
    }

    public boolean isRequiredForInspection() {
        return this.requiredForInspection;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String getFqn() {
        if (this.fullyQualifiedName == null) {
            this.assignFullyQualifiedName();
        }
        return this.fullyQualifiedName;
    }

    private void assignFullyQualifiedName() {
        this.fullyQualifiedName = this.declaringDescriptor.getType() + "." + this.name;
    }

    public boolean isDeployedSpecific() {
        return this.deployedSpecific;
    }

    public String toString() {
        return this.getFqn();
    }

    public Object emptyValue() {
        if (this.primitive) {
            switch (this.kind) {
                case INTEGER: {
                    return ZERO;
                }
                case BOOLEAN: {
                    return Boolean.FALSE;
                }
            }
            throw new IllegalArgumentException("Only INTEGER and BOOLEAN can be primitive");
        }
        switch (this.kind) {
            case SET_OF_STRING: 
            case SET_OF_CI: {
                return Sets.newHashSet();
            }
            case LIST_OF_STRING: 
            case LIST_OF_CI: {
                return Lists.newArrayList();
            }
            case MAP_STRING_STRING: {
                return Maps.newHashMap();
            }
        }
        return null;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setAsContainment(boolean asContainment) {
        this.asContainment = asContainment;
    }

    protected void setCategory(String category) {
        this.category = category;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setPassword(boolean password) {
        this.password = password;
    }

    protected void setRequired(boolean required) {
        this.required = required;
    }

    protected void setSize(Property.Size size) {
        this.size = size;
    }

    protected void setKind(PropertyKind kind) {
        this.kind = kind;
        this.primitive = false;
    }

    protected void setPrimitiveKind(PropertyKind kind) {
        Preconditions.checkArgument((kind == PropertyKind.INTEGER || kind == PropertyKind.BOOLEAN ? 1 : 0) != 0, (Object)"Only INTEGER and BOOLEAN can be primitive kinds");
        this.kind = kind;
        this.primitive = true;
    }

    protected void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    protected void setEnumClass(Class<?> enumClass) {
        this.enumClass = enumClass;
    }

    protected void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    protected void setReferencedType(Type referencedType) {
        this.referencedType = referencedType;
    }

    protected void setInspectionProperty(boolean inspectionProperty) {
        this.inspectionProperty = inspectionProperty;
    }

    protected void setTransient(boolean aTransient) {
        this.isTransient = aTransient;
    }

    protected void setCandidateValuesFilter(String candidateValuesFilter) {
        this.candidateValuesFilter = candidateValuesFilter;
    }

    protected void setDeployedSpecific(boolean deployedSpecific) {
        this.deployedSpecific = deployedSpecific;
    }

    protected void setDeclaringDescriptor(LocalDescriptor declaringDescriptor) {
        this.declaringDescriptor = declaringDescriptor;
    }

    protected void setRequiredForInspection(boolean requiredForInspection) {
        this.requiredForInspection = requiredForInspection;
    }

    protected void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    protected void setValidationRules(Set<Validator<?>> validationRules) {
        this.validationRules = validationRules;
    }

    protected void registerDefault(String defaultValue) {
        GlobalContext.register((PropertyDescriptor)this, defaultValue);
    }

    protected void registerDefault(PropertyDescriptor superPropertyDescriptor) {
        GlobalContext.register((PropertyDescriptor)this, superPropertyDescriptor);
    }
}

