package com.xebialabs.deployit.booter.local;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.common.collect.Iterators;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.booter.local.utils.Closeables.closeQuietly;
import static com.xebialabs.xlplatform.utils.ClassLoaderUtils$.MODULE$;

public class PluginVersions {

    private static final Map<String, String> PLUGIN_VERSIONS = newHashMap();

    static void init() {
        try {
            Enumeration<URL> resources = MODULE$.classLoader().getResources("plugin-version.properties");
            ArrayList<URL> urls = newArrayList(Iterators.forEnumeration(resources));
            for (URL url : urls) {
                readPluginVersion(Resources.asByteSource(url));
            }
        } catch (IOException e) {
            logger.error("Couldn't read plugin-version.properties", e);
            throw new IllegalStateException(e);
        }
    }

    public static String getVersionFor(String plugin) {
        return PLUGIN_VERSIONS.get(plugin);
    }

    public static Set<String> getRegisteredPlugins() {
        return PLUGIN_VERSIONS.keySet();
    }

    private static void readPluginVersion(ByteSource source) throws IOException {
        InputStream input = source.openStream();
        try {
            Properties properties = new Properties();
            properties.load(input);
            String plugin = properties.getProperty("plugin");
            String version = properties.getProperty("version");
            PLUGIN_VERSIONS.put(plugin, version);
        } finally {
            closeQuietly(input);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(PluginVersions.class);
}
