package com.xebialabs.deployit.booter.local;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import com.xebialabs.deployit.plugin.api.reflect.ConfigurationItemPostConstructor;
import com.xebialabs.deployit.plugin.api.reflect.Process;
import com.xebialabs.deployit.plugin.api.reflect.Type;

import nl.javadude.scannit.Scannit;

import static java.util.stream.Stream.concat;
import static java.util.stream.Stream.of;

final class ConfigurationItemPostProcessors {

    private static final Multimap<Type, ConfigurationItemPostConstructor> processorsPerType = ArrayListMultimap.create();

    private ConfigurationItemPostProcessors() {
    }

    static void registerPostProcessors() {
        Set<Class<?>> processors = new HashSet<>();
        Scannit scannit = Scannit.getInstance();
        processors.addAll(scannit.getTypesAnnotatedWith(Process.class));
        processors.retainAll(scannit.getSubTypesOf(ConfigurationItemPostConstructor.class));
        processors.stream().forEach(ConfigurationItemPostProcessors::registerPostProcessor);
    }

    static Set<ConfigurationItemPostConstructor> getProcessors(Type type) {
        List<Type> superTypes = type.getDescriptor().getSuperClasses();
        Set<Type> interfaces = type.getDescriptor().getInterfaces();
        return concat(concat(of(type), superTypes.stream()), interfaces.stream()).flatMap(t -> processorsPerType.get(t).stream()).collect(Collectors.toSet());
    }

    static private void registerPostProcessor(Class<?> postProcessorClass) {
        try {
            String type = postProcessorClass.getAnnotation(Process.class).type();
            processorsPerType.put(Type.valueOf(type), (ConfigurationItemPostConstructor) postProcessorClass.newInstance());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
