package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.xebialabs.deployit.plugin.api.reflect.PropertyKind.ENUM;
import static java.lang.String.format;

class GeneratedDeployablePropertyDescriptor extends LocalPropertyDescriptor {

    public GeneratedDeployablePropertyDescriptor(LocalDescriptor descriptor, LocalPropertyDescriptor propertyDescriptor) {
        setName(propertyDescriptor.getName());
        setDeclaringDescriptor(descriptor);
        initMetadataFromDescriptor(propertyDescriptor);
    }

    private void initMetadataFromDescriptor(LocalPropertyDescriptor propertyDescriptor) {
        // Generated 'simple' Deployable properties always are of kind String so that placeholder/dictionaries values can be filled.
        setKind(propertyDescriptor.getKind().isSimple() ? PropertyKind.STRING : propertyDescriptor.getKind());
        setCategory(propertyDescriptor.getCategory());
        setLabel(propertyDescriptor.getLabel());
        setRequired(false);
        setPassword(propertyDescriptor.isPassword());
        setSize(propertyDescriptor.getSize());
        initDescription(propertyDescriptor);
        setValidationRules(propertyDescriptor.validationRules);
    }

    private void initDescription(PropertyDescriptor propertyDescriptor) {
        String description = format("%s (%s)", propertyDescriptor.getDescription(), propertyDescriptor.getKind().name().toLowerCase());
        if (propertyDescriptor.getKind() == ENUM) {
            description += format(" values(%s)", String.join(", ", propertyDescriptor.getEnumValues()));
        }
        if (propertyDescriptor.getKind().isSimple() && propertyDescriptor.getDefaultValue() != null) {
            description += format(" default(%s)", propertyDescriptor.getDefaultValue());
        }
        setDescription(description);
    }

    @Override
    public Object get(ConfigurationItem item) {
        return getDeclaringDescriptor().getSyntheticPropertyValue(item, getName());
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        getDeclaringDescriptor().setSyntheticPropertyValue(item, getName(), value);
    }
}
