package com.xebialabs.deployit.booter.local.validation;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import org.apache.commons.lang.StringUtils;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = IntegerAndPlaceholderValidator.Validator.class, type = "integerAndPlaceholder")
public @interface IntegerAndPlaceholderValidator {

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        @Override
        public void validate(String value, ValidationContext context) {
            if (!(isPlaceholder(value) || StringUtils.isNumeric(value))) {
                context.error("%s is not a number/placeholder", value);
            }
        }

        private boolean isPlaceholder(String value) {
            return StringUtils.startsWith(value, "{{") && StringUtils.endsWith(value, "}}");
        }
    }
}
