/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.Converter;
import com.xebialabs.deployit.booter.local.Converters;
import com.xebialabs.deployit.booter.local.EnumClassConverter;
import com.xebialabs.deployit.booter.local.EnumValuesConverter;
import com.xebialabs.deployit.booter.local.GlobalContext;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorHelper;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptorWithDifferentOwner;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.validation.CollectionTypeValidator;
import com.xebialabs.deployit.booter.local.validation.ReferenceCollectionTypeValidator;
import com.xebialabs.deployit.booter.local.validation.ReferenceTypeValidator;
import com.xebialabs.deployit.booter.local.validation.RequiredValidator;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.reflect.InputHint;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.overthere.util.OverthereUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalPropertyDescriptor
implements PropertyDescriptor {
    private static final Integer ZERO = 0;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LocalDescriptor declaringDescriptor;
    private String fullyQualifiedName;
    private String name;
    private boolean asContainment;
    private String category;
    private String description;
    private String label;
    private boolean password;
    private boolean required;
    private Property.Size size;
    private PropertyKind kind;
    private List<String> enumValues;
    private Class<?> enumClass;
    private Type referencedType;
    private boolean hidden;
    private boolean inspectionProperty;
    private boolean requiredForInspection;
    private boolean isTransient;
    protected Set<Validator<?>> validationRules = new HashSet();
    private Set<String> aliases = new HashSet<String>();
    private String candidateValuesFilter;
    private boolean deployedSpecific;
    private boolean primitive;
    private InputHint inputHint;

    protected void reInitializeRequired() {
        if (this.kind == PropertyKind.BOOLEAN && this.required) {
            this.logger.debug("Required boolean property [{}] will be treated as an optional property.", (Object)this);
            this.required = false;
        }
        if ((this.kind == PropertyKind.LIST_OF_CI || this.kind == PropertyKind.SET_OF_CI) && this.asContainment && this.required) {
            this.logger.debug("Required asContainment collection of configuration items [{}] will be treated as an optional property.", (Object)this);
            this.required = false;
        }
    }

    LocalPropertyDescriptor copyWithNewDescriptor(LocalDescriptor declaringDescriptor) {
        return new LocalPropertyDescriptorWithDifferentOwner(this, declaringDescriptor);
    }

    protected void setFromPropertyDescriptor(LocalPropertyDescriptor pd) {
        this.setName(pd.getName());
        this.setAsContainment(pd.isAsContainment());
        this.setCategory(pd.getCategory());
        this.setDescription(pd.getDescription());
        this.setLabel(pd.getLabel());
        this.setPassword(pd.isPassword());
        this.setRequired(pd.isRequired());
        this.setSize(pd.getSize());
        this.setKind(pd.getKind());
        this.setEnumValues(pd.getEnumValues());
        this.setEnumClass(pd.getEnumClass());
        this.setReferencedType(pd.getReferencedType());
        this.setHidden(pd.isHidden());
        this.setInspectionProperty(pd.isInspectionProperty());
        this.setRequiredForInspection(pd.isRequiredForInspection());
        this.setValidationRules(new HashSet(pd.validationRules));
        this.setAliases(new HashSet<String>(pd.getAliases()));
        this.setTransient(pd.isTransient());
        this.setCandidateValuesFilter(pd.getCandidateValuesFilter());
        this.setDeployedSpecific(pd.isDeployedSpecific());
        this.setInputHint(pd.getInputHint());
    }

    public void verify(Verifications verifications) {
        this.verifyName(verifications, "name");
        this.verifyName(verifications, "displayName");
        this.verifyName(verifications, "id");
        this.verifyName(verifications, "type");
        verifications.verify(!this.getName().contains("$"), "Cannot define a property named '%s' because it contains a '$'", this.getName());
        verifications.verify(!this.hidden || this.isTransient, "Hidden property '%s' should be transient", this);
        boolean isCiKind = EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI, PropertyKind.CI).contains(this.kind);
        verifications.verify(!this.asContainment || isCiKind, "'%s' can only be an as containment relation if it is a 'set_of_ci', 'list_of_ci' or 'ci' kind property", this);
        verifications.verify(this.referencedType == null || isCiKind, "'%s' can only have reference type '%s' set when it is a (Set/List of) CI kind property", this, this.referencedType);
        verifications.verify(this.candidateValuesFilter == null || isCiKind, "'%s' can only define a candidate-values-filter if it is a 'set_of_ci', 'list_of_ci' or 'ci' kind property", this);
        verifications.verify(this.candidateValuesFilter == null || this.findFilterMethod() != null, "'%s' refers to an unknown candidate-values-filter '%s'", this, this.candidateValuesFilter);
        verifications.verify(!this.asContainment || isCiKind, "'%s' can only be an as containment relation if it is a 'set_of_ci', 'list_of_ci' or 'ci' kind property", this);
        verifications.verify(this.referencedType == null || isCiKind, "'%s' can only have reference type '%s' set when it is a (Set/List of) CI kind property", this, this.referencedType);
        boolean isPasswordKind = EnumSet.of(PropertyKind.STRING, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_STRING, PropertyKind.MAP_STRING_STRING).contains(this.kind);
        if (this.password && !isPasswordKind) {
            Deprecations.deprecated((String)"'%s' can only be a password property if it is a 'string', 'set_of_string', 'list_of_string' or 'map_string_string' kind property", (Object[])new Object[]{this});
        }
        this.verifyAliases(verifications);
    }

    private void verifyAliases(Verifications verifications) {
        if (!this.aliases.isEmpty()) {
            for (PropertyDescriptor otherPd : this.declaringDescriptor.getPropertyDescriptors()) {
                LocalPropertyDescriptor pd = (LocalPropertyDescriptor)otherPd;
                if (otherPd.equals(this)) continue;
                verifications.verify(this.declaringDescriptor.getType(), !this.aliases.contains(pd.getName()), "Aliases of [%s] contain name [%s] which is an existing property.", this, pd.getName());
                HashSet<String> intersection = new HashSet<String>(this.aliases);
                intersection.retainAll(pd.aliases);
                verifications.verify(this.declaringDescriptor.getType(), intersection.isEmpty(), "Aliases of [%s] conflict with aliases of [%s]. Conflicting: %s", this, pd, intersection);
            }
        }
    }

    private void verifyName(Verifications verifications, String name) {
        verifications.verify(!this.name.equals(name), "Cannot define a property named '%s' on %s", name, this.declaringDescriptor);
    }

    private Method findFilterMethod() {
        Set filters = Scannit.getInstance().getMethodsAnnotatedWith(CandidateValuesFilter.class);
        return filters.stream().filter(i -> i.getAnnotation(CandidateValuesFilter.class).name().equals(this.candidateValuesFilter)).findFirst().orElse(null);
    }

    void initEnumValues(Class<?> enumClass) {
        this.enumValues = new ArrayList<String>();
        this.enumClass = enumClass;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            this.enumValues.add(enumValue.name());
        }
    }

    protected void addDefaultValidationRules() {
        if (this.required && !this.asContainment && this.kind != PropertyKind.BOOLEAN) {
            this.validationRules.add(new RequiredValidator());
        }
        if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_CI, PropertyKind.LIST_OF_STRING).contains(this.kind)) {
            this.validationRules.add(new CollectionTypeValidator(this));
        }
        if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(this.kind)) {
            this.validationRules.add(new ReferenceCollectionTypeValidator(this));
        } else if (PropertyKind.CI == this.kind) {
            this.validationRules.add(new ReferenceTypeValidator(this));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAsContainment() {
        return this.asContainment;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Property.Size getSize() {
        return this.size;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public List<String> getEnumValues() {
        return this.enumValues != null ? new ArrayList<String>(this.enumValues) : this.enumValues;
    }

    public Class<?> getEnumClass() {
        return this.enumClass;
    }

    public LocalDescriptor getDeclaringDescriptor() {
        return this.declaringDescriptor;
    }

    public Type getReferencedType() {
        return this.referencedType;
    }

    public Object getDefaultValue() {
        return this.convertValue(GlobalContext.lookup(this));
    }

    Converter createConverter() {
        if (this.kind == PropertyKind.ENUM) {
            if (this.enumClass != null) {
                return new EnumClassConverter(this.enumClass);
            }
            return new EnumValuesConverter(this.enumValues);
        }
        return Converters.createStatelessConverter(this.name, this.kind);
    }

    private Object convertValue(String val) {
        if (val == null) {
            return null;
        }
        return this.createConverter().convert(val);
    }

    private Collection<String> splitValue(String val) {
        return Arrays.stream(val.split(",")).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public String getCandidateValuesFilter() {
        return this.candidateValuesFilter;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public final void set(ConfigurationItem item, Object value) {
        if (value instanceof String) {
            value = this.convertValue((String)value);
        } else if (value == null) {
            value = this.getDefaultValue();
        }
        if (value == null) {
            value = this.emptyValue();
        }
        this.logger.trace("Setting value [{}] on property [{}] of CI [{}]", new Object[]{value, this.getFqn(), item.getId()});
        this.doSetValue(item, value);
    }

    protected abstract void doSetValue(ConfigurationItem var1, Object var2);

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.areEqual(item, other, ConfigurationItem::getId);
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other, Function<ConfigurationItem, Object> identifierExtractor) {
        return this.areEqual(item, other, identifierExtractor, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem item, ConfigurationItem other, Function<ConfigurationItem, Object> identifierExtractor, Set<String> itemsBeingCompared) {
        Object left = this.get(item);
        Object right = this.get(other);
        this.logger.trace("Comparing {}: old [{}] <-> new [{}]", new Object[]{this.getFqn(), left, right});
        return this.areValuesEqual(left, right, identifierExtractor, itemsBeingCompared);
    }

    private boolean areEqualByIdentifier(ConfigurationItem left, ConfigurationItem right, Function<ConfigurationItem, Object> identifierExtractor) {
        return identifierExtractor.apply(left).equals(identifierExtractor.apply(right));
    }

    private boolean areValuesEqual(Object itemValue, Object otherValue, Function<ConfigurationItem, Object> identifierExtractor, Set<String> itemsBeingCompared) {
        if (itemValue == null) {
            return otherValue == null;
        }
        if (otherValue == null) {
            return false;
        }
        switch (this.kind) {
            case SET_OF_STRING: {
                Set<String> symmetricDiff = this.symmetricDifference((Set)itemValue, (Set)otherValue);
                return symmetricDiff.isEmpty();
            }
            case SET_OF_CI: {
                Stream cis = Stream.concat(((Set)itemValue).stream(), ((Set)otherValue).stream());
                Map index = cis.collect(Collectors.groupingBy(identifierExtractor, Collectors.toList()));
                for (Object key : index.keySet()) {
                    ConfigurationItem rhs;
                    Collection cisToCompare = index.get(key);
                    if (cisToCompare.size() != 2) {
                        return false;
                    }
                    Iterator itemIterator = cisToCompare.iterator();
                    ConfigurationItem lhs = (ConfigurationItem)itemIterator.next();
                    if (this.areCiEqual(lhs, rhs = (ConfigurationItem)itemIterator.next(), identifierExtractor, itemsBeingCompared)) continue;
                    return false;
                }
                return true;
            }
            case CI: {
                ConfigurationItem itemValueAsCi = (ConfigurationItem)itemValue;
                ConfigurationItem otherValueAsCi = (ConfigurationItem)otherValue;
                if (this.areEqualByIdentifier(itemValueAsCi, otherValueAsCi, identifierExtractor)) {
                    LocalDescriptor descriptor = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)itemValueAsCi.getType());
                    return LocalDescriptorHelper.areEqualDeeply(descriptor, itemValueAsCi, otherValueAsCi, itemsBeingCompared);
                }
                return false;
            }
            case MAP_STRING_STRING: {
                Map left = (Map)itemValue;
                Map right = (Map)otherValue;
                Set<String> diff = this.symmetricDifference(left.keySet(), right.keySet());
                if (!diff.isEmpty()) {
                    return false;
                }
                for (Map.Entry leftKV : left.entrySet()) {
                    if (((String)leftKV.getValue()).equals(right.get(leftKV.getKey()))) continue;
                    return false;
                }
                return true;
            }
            case LIST_OF_STRING: {
                List leftStrings = (List)itemValue;
                List rightStrings = (List)otherValue;
                if (leftStrings.size() != rightStrings.size()) {
                    return false;
                }
                for (int i = 0; i < leftStrings.size(); ++i) {
                    if (((String)leftStrings.get(i)).equals(rightStrings.get(i))) continue;
                    return false;
                }
                return true;
            }
            case LIST_OF_CI: {
                List lhs = (List)itemValue;
                List rhs = (List)otherValue;
                if (lhs.size() != rhs.size()) {
                    return false;
                }
                Iterator lIter = lhs.iterator();
                Iterator rIter = rhs.iterator();
                while (lIter.hasNext()) {
                    ConfigurationItem rItem;
                    ConfigurationItem lItem = (ConfigurationItem)lIter.next();
                    if (this.areCiEqual(lItem, rItem = (ConfigurationItem)rIter.next(), identifierExtractor, itemsBeingCompared)) continue;
                    return false;
                }
                return true;
            }
        }
        return itemValue.equals(otherValue);
    }

    private Set<String> symmetricDifference(Set<String> leftSet, Set<String> rightSet) {
        HashSet<String> symmetricDiff = new HashSet<String>(leftSet);
        symmetricDiff.addAll(rightSet);
        HashSet<String> tmp = new HashSet<String>(leftSet);
        tmp.retainAll(rightSet);
        symmetricDiff.removeAll(tmp);
        return symmetricDiff;
    }

    private boolean areCiEqual(ConfigurationItem lItem, ConfigurationItem rItem, Function<ConfigurationItem, Object> identifierExtractor, Set<String> itemsBeingCompared) {
        if (this.areEqualByIdentifier(lItem, rItem, identifierExtractor) && lItem.getType().equals((Object)rItem.getType())) {
            LocalDescriptor descriptor = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)lItem.getType());
            return LocalDescriptorHelper.areEqualDeeply(descriptor, lItem, rItem, itemsBeingCompared);
        }
        return false;
    }

    void validate(ConfigurationItem ci, List<ValidationMessage> messages) {
        ValidationContext context = (message, params) -> messages.add(new ValidationMessage(ci.getId(), this.name, String.format(message, params)));
        for (Validator<?> validationRule : this.validationRules) {
            validationRule.validate(this.get(ci), context);
        }
    }

    void validateInputHint(ConfigurationItem configurationItem, List<ValidationMessage> validationMessages) {
        if (this.inputHint != null) {
            ValidationContext warningContext = (validationMessage, params) -> validationMessages.add(ValidationMessage.warn((String)configurationItem.getId(), (String)this.name, (String)String.format(validationMessage, params)));
            for (Validator validationRule : this.inputHint.getValidationRules()) {
                validationRule.validate(this.get(configurationItem), warningContext);
            }
        }
    }

    public boolean isInspectionProperty() {
        return this.inspectionProperty;
    }

    public boolean isRequiredForInspection() {
        return this.requiredForInspection;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String getFqn() {
        if (this.fullyQualifiedName == null) {
            this.assignFullyQualifiedName();
        }
        return this.fullyQualifiedName;
    }

    private void assignFullyQualifiedName() {
        this.fullyQualifiedName = this.declaringDescriptor.getType() + "." + this.name;
    }

    public boolean isDeployedSpecific() {
        return this.deployedSpecific;
    }

    public InputHint getInputHint() {
        return this.inputHint;
    }

    public String toString() {
        return this.getFqn();
    }

    public Object emptyValue() {
        if (this.primitive) {
            switch (this.kind) {
                case INTEGER: {
                    return ZERO;
                }
                case BOOLEAN: {
                    return Boolean.FALSE;
                }
            }
            throw new IllegalArgumentException("Only INTEGER and BOOLEAN can be primitive");
        }
        switch (this.kind) {
            case SET_OF_STRING: 
            case SET_OF_CI: {
                return new HashSet();
            }
            case LIST_OF_STRING: 
            case LIST_OF_CI: {
                return new ArrayList();
            }
            case MAP_STRING_STRING: {
                return new HashMap();
            }
        }
        return null;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setAsContainment(boolean asContainment) {
        this.asContainment = asContainment;
    }

    protected void setCategory(String category) {
        this.category = category;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setPassword(boolean password) {
        this.password = password;
    }

    protected void setRequired(boolean required) {
        this.required = required;
    }

    protected void setSize(Property.Size size) {
        this.size = size;
    }

    protected void setKind(PropertyKind kind) {
        this.kind = kind;
        this.primitive = false;
    }

    protected void setPrimitiveKind(PropertyKind kind) {
        OverthereUtils.checkArgument((kind == PropertyKind.INTEGER || kind == PropertyKind.BOOLEAN ? 1 : 0) != 0, (String)"Only INTEGER and BOOLEAN can be primitive kinds", (Object[])new Object[0]);
        this.kind = kind;
        this.primitive = true;
    }

    protected void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    protected void setEnumClass(Class<?> enumClass) {
        this.enumClass = enumClass;
    }

    protected void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    protected void setReferencedType(Type referencedType) {
        this.referencedType = referencedType;
    }

    protected void setInspectionProperty(boolean inspectionProperty) {
        this.inspectionProperty = inspectionProperty;
    }

    protected void setTransient(boolean aTransient) {
        this.isTransient = aTransient;
    }

    protected void setCandidateValuesFilter(String candidateValuesFilter) {
        this.candidateValuesFilter = candidateValuesFilter;
    }

    protected void setDeployedSpecific(boolean deployedSpecific) {
        this.deployedSpecific = deployedSpecific;
    }

    protected void setDeclaringDescriptor(LocalDescriptor declaringDescriptor) {
        this.declaringDescriptor = declaringDescriptor;
    }

    protected void setRequiredForInspection(boolean requiredForInspection) {
        this.requiredForInspection = requiredForInspection;
    }

    protected void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    protected void setValidationRules(Set<Validator<?>> validationRules) {
        this.validationRules = validationRules;
    }

    protected void setInputHint(InputHint inputHint) {
        this.inputHint = inputHint;
    }

    protected void registerDefault(String defaultValue) {
        GlobalContext.register((PropertyDescriptor)this, defaultValue);
    }

    protected void registerDefault(PropertyDescriptor superPropertyDescriptor) {
        GlobalContext.register((PropertyDescriptor)this, superPropertyDescriptor);
    }
}

