package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;

import java.util.Set;
import java.util.function.Function;

class LocalDescriptorHelper {
    private static Function<ConfigurationItem, Object> getPropertyIdentityExtractor(LocalPropertyDescriptor pd) {
        Type referencedType = pd.getReferencedType();
        Function<Class, Boolean> isAssignableTo = (t) -> referencedType != null && referencedType.getDescriptor().isAssignableTo(t);
        return isAssignableTo.apply(EmbeddedDeployable.class) || isAssignableTo.apply(Deployable.class) ? ConfigurationItem::getName : ConfigurationItem::getId;
    }

    static boolean areEqualDeeply(LocalDescriptor descriptor,
                                  ConfigurationItem item,
                                  ConfigurationItem other,
                                  Set<String> itemsCompared) {
        if (item == null) {
            return other == null;
        }

        if (!descriptor.getType().equals(item.getType()) || !descriptor.getType().equals(other.getType())) {
            return false;
        }

        if (!itemsCompared.add(item.getId())) {
            return true;
        }

        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            LocalPropertyDescriptor propertyDescriptor = (LocalPropertyDescriptor) pd;
            Function<ConfigurationItem, Object> identifierExtractor = getPropertyIdentityExtractor(propertyDescriptor);
            if (!propertyDescriptor.areEqual(item, other, identifierExtractor, itemsCompared)) {
                return false;
            }
        }
        return true;
    }
}