package com.xebialabs.deployit.booter.local;

import com.xebialabs.xlplatform.synthetic.BaseTypeSpecification;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Parameters;

public class GeneratedParameterTypeDefinition extends TypeDefinition {

    private final MethodSpecification methodSpecification;

    public GeneratedParameterTypeDefinition(BaseTypeSpecification owner, MethodSpecification methodSpecification) {
        this.owner = owner.getTypeName().toType();
        this.methodSpecification = methodSpecification;
        this.type = TypeDefinitions.generatedParameterType(this.owner, methodSpecification.getName());
        this.superType = Type.valueOf(Parameters.class);
    }

    @Override
    protected LocalDescriptor createDescriptor(final TypeDefinitions typeDefinitions) {
        return new GeneratedParameterLocalDescriptor(this.type, methodSpecification);
    }
}
