/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalMethodDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DescriptorVerification {
    static final String PLACEHOLDERS_FIELD = "placeholders";

    DescriptorVerification() {
    }

    static void verify(Verifications verifications, Descriptor descriptor) {
        DescriptorVerification.verifyReferenceTypes(verifications, descriptor);
        DescriptorVerification.verifyNonArtifactDoesNotHavePlaceholders(verifications, descriptor);
        DescriptorVerification.verifyArtifactInterfaces(verifications, descriptor);
        if (!descriptor.isVirtual()) {
            DescriptorVerification.verifyNoArgsConstructor(verifications, descriptor);
            DescriptorVerification.verifyJavaClassIsNotAbstract(verifications, descriptor);
            DescriptorVerification.verifyDeployedHasDeployableAndContainerType(verifications, descriptor);
            DescriptorVerification.verifyDeployedHasCorrectInheritance(verifications, descriptor);
            DescriptorVerification.verifyHiddenRequiredPropertiesHaveDefaultValue(verifications, descriptor);
            DescriptorVerification.verifyControlTasks(verifications, descriptor);
        }
        if (!descriptor.isInspectable()) {
            DescriptorVerification.verifyNoInspectionProperties(verifications, descriptor);
        }
        DescriptorVerification.verifyExtendsBaseConfigurationItem(verifications, descriptor);
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            ((LocalPropertyDescriptor)propertyDescriptor).verify(verifications);
        }
        DescriptorVerification.verifyAsContainmentProperties(verifications, descriptor);
    }

    private static void verifyNoArgsConstructor(Verifications verifications, Descriptor descriptor) {
        Constructor<?>[] declaredConstructors;
        for (Constructor<?> declaredConstructor : declaredConstructors = descriptor.getClazz().getDeclaredConstructors()) {
            if (declaredConstructor.getParameterTypes().length != 0) continue;
            return;
        }
        verifications.verify(descriptor.getType(), false, "ConfigurationItem should have a no-arguments constructor.", new Object[0]);
    }

    private static void verifyAsContainmentProperties(Verifications verifications, Descriptor descriptor) {
        Stream from = descriptor.getPropertyDescriptors().stream();
        Stream<PropertyDescriptor> filteredCiProperties = from.filter(input -> input.isAsContainment() && input.getKind() == PropertyKind.CI);
        verifications.verify(filteredCiProperties.count() <= 1L, "Can only have at most 1 asContainment property with kind = 'ci', got %s", filteredCiProperties);
    }

    private static void verifyExtendsBaseConfigurationItem(Verifications verifications, Descriptor descriptor) {
        if (descriptor.getClazz() != null) {
            verifications.verify(BaseConfigurationItem.class.isAssignableFrom(descriptor.getClazz()), "ConfigurationItem [%s] does not extend BaseConfigurationItem", descriptor.getType());
        }
    }

    private static void verifyNoInspectionProperties(Verifications verifications, Descriptor descriptor) {
        Type type = descriptor.getType();
        List inspectableProperties = descriptor.getPropertyDescriptors().stream().filter(PropertyDescriptor::isInspectionProperty).collect(Collectors.toList());
        verifications.verify(type, inspectableProperties.isEmpty(), "Type [%s] is not inspectable but has @InspectionProperty properties %s", type, inspectableProperties);
    }

    private static void verifyControlTasks(Verifications verifications, Descriptor descriptor) {
        for (MethodDescriptor controlTask : descriptor.getControlTasks()) {
            ((LocalMethodDescriptor)controlTask).verify(verifications);
        }
    }

    private static void verifyReferenceTypes(Verifications verifications, Descriptor descriptor) {
        for (PropertyDescriptor p : descriptor.getPropertyDescriptors()) {
            PropertyKind kind = p.getKind();
            if (kind != PropertyKind.CI && kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
            verifications.verify(descriptor.getType(), DescriptorVerification.isValidReferencedType(p.getReferencedType()), "Property %s of type %s refers to non-existing type %s", p.getName(), ((LocalPropertyDescriptor)p).getDeclaringDescriptor().getType(), p.getReferencedType());
        }
    }

    private static boolean isValidReferencedType(Type referencedType) {
        if (referencedType.exists()) {
            return true;
        }
        DescriptorRegistryId descriptorRegistryId = referencedType.getTypeSource();
        IDescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)descriptorRegistryId);
        for (Descriptor d : descriptorRegistry._getDescriptors()) {
            if (d.getSuperClasses().contains(referencedType)) {
                return true;
            }
            if (!d.getInterfaces().contains(referencedType)) continue;
            return true;
        }
        return false;
    }

    private static void verifyNonArtifactDoesNotHavePlaceholders(Verifications verifications, Descriptor descriptor) {
        if (!descriptor.isAssignableTo(Artifact.class)) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                verifications.verify(descriptor.getType(), !propertyDescriptor.getName().equals(PLACEHOLDERS_FIELD), "Cannot have a field 'placeholders' as 'udm.Artifact' is not implemented.", new Object[0]);
            }
        }
    }

    private static void verifyArtifactInterfaces(Verifications verifications, Descriptor descriptor) {
        Type type = descriptor.getType();
        if (descriptor.isAssignableTo(Deployable.class) && descriptor.isAssignableTo(Artifact.class)) {
            verifications.verify(type, descriptor.isAssignableTo(SourceArtifact.class), "Implements both 'udm.Deployable' and 'udm.Artifact' interface. Must also implement the 'udm.SourceArtifact' interface", new Object[0]);
            verifications.verify(type, descriptor.isAssignableTo(DeployableArtifact.class), "Implements the 'udm.Deployable' and 'udm.Artifact' interface. Must also implement the 'udm.DeployableArtifact' interface", new Object[0]);
        }
        if (descriptor.isAssignableTo(Deployed.class) && descriptor.isAssignableTo(Artifact.class)) {
            verifications.verify(type, descriptor.isAssignableTo(DerivedArtifact.class), "Implements the 'udm.Deployed' and 'udm.Artifact' interface. Must also implement the 'udm.DerivedArtifact' interface", new Object[0]);
        }
    }

    private static void verifyJavaClassIsNotAbstract(Verifications verifications, Descriptor descriptor) {
        verifications.verify(descriptor.getType(), !Modifier.isAbstract(descriptor.getClazz().getModifiers()), "Non-virtual type %s has an abstract Java class %s", descriptor.getType(), descriptor.getClazz().getName());
    }

    private static void verifyDeployedHasDeployableAndContainerType(Verifications verifications, Descriptor descriptor) {
        Type type = descriptor.getType();
        DescriptorRegistryId descriptorRegistryId = type.getTypeSource();
        IDescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)descriptorRegistryId);
        Type deployedType = descriptor.isAssignableTo(Deployed.class) ? descriptorRegistry.lookupType(Deployed.class) : (descriptor.isAssignableTo(EmbeddedDeployed.class) ? descriptorRegistry.lookupType(EmbeddedDeployed.class) : null);
        Type deplyableType = descriptor.getDeployableType();
        Type containerType = descriptor.getContainerType();
        if (deployedType != null) {
            verifications.verify(type, deplyableType != null, "Non-virtual type %s is a sub-type of %s but does not have a deployable-type", type, deployedType);
            verifications.verify(type, containerType != null, "Non-virtual type %s is a sub-type of %s but does not have a container-type", type, deployedType);
        } else {
            verifications.verify(type, deplyableType == null, "Non-virtual type %s should not have a deployable-type", type);
            verifications.verify(type, containerType == null, "Non-virtual type %s should not have a container-type", type);
        }
    }

    private static void verifyDeployedHasCorrectInheritance(Verifications verifications, Descriptor descriptor) {
        DescriptorRegistryId descriptorRegistryId = descriptor.getType().getTypeSource();
        IDescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)descriptorRegistryId);
        Type deployedType = descriptorRegistry.lookupType(Deployed.class);
        Type type = descriptor.getType();
        Type deployableType = descriptor.getDeployableType();
        Type containerType = descriptor.getContainerType();
        if (descriptor.isAssignableTo(deployedType)) {
            Type directSuperType = (Type)descriptor.getSuperClasses().get(0);
            Descriptor superDescriptor = directSuperType.getDescriptor();
            Type superDeployable = superDescriptor.getDeployableType();
            Type superContainer = superDescriptor.getContainerType();
            verifications.verify(descriptor.getType(), superDeployable == null || descriptor.getDeployableType().instanceOf(superDeployable), "Type %s inherits from %s<%s, %s> but doesn't have a deployable subtype (%s).", type, directSuperType, superDeployable, superContainer, deployableType);
            verifications.verify(descriptor.getType(), superContainer == null || descriptor.getContainerType().instanceOf(superContainer), "Type %s inherits from %s<%s, %s> but doesn't have a container subtype (%s).", type, directSuperType, superDeployable, superContainer, containerType);
        }
    }

    private static void verifyHiddenRequiredPropertiesHaveDefaultValue(Verifications verifications, Descriptor descriptor) {
        Type type = descriptor.getType();
        descriptor.getPropertyDescriptors().stream().filter(p -> p.isHidden() && p.isRequired()).forEach(p -> verifications.verify(type, p.getDefaultValue() != null, "Hidden required property %s of non-virtual type %s must have a default value", p.getName(), type));
    }
}

