/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.xml;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlElement;
import com.xebialabs.xlplatform.synthetic.xml.XmlPropertySpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlMethodSpecification
extends XmlElement
implements MethodSpecification {
    private static final Set<String> RESERVED_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("name", "label", "description", "parameters-type"));

    public XmlMethodSpecification(IDescriptorRegistry descriptorRegistry, Element element) {
        super(descriptorRegistry, element);
    }

    @Override
    public String getName() {
        return this.getRequiredStringAttribute(this.element, "name");
    }

    @Override
    public List<PropertySpecification> getParameters() {
        ArrayList<PropertySpecification> parameters = new ArrayList<PropertySpecification>();
        if (!this.childByName(this.element, "parameters"::equals).hasNext()) {
            return parameters;
        }
        Element parametersElement = this.childByName(this.element, "parameters"::equals).next();
        this.childByName(parametersElement, "parameter"::equals).forEachRemaining(parameter -> parameters.add(new XmlPropertySpecification(this.descriptorRegistry, (Element)parameter)));
        return parameters;
    }

    @Override
    public Optional<String> getLabel() {
        return this.getOptionalString(this.element, "label");
    }

    @Override
    public Optional<String> getDescription() {
        return this.getOptionalString(this.element, "description");
    }

    @Override
    public Optional<String> getDelegate() {
        return this.getOptionalString(this.element, "delegate");
    }

    @Override
    public Optional<Type> getParameterType() {
        return this.getOptionalType(this.element, "parameters-type");
    }

    @Override
    public Map<String, String> getAttributes() {
        return XmlMethodSpecification.readAttributes(this.element);
    }

    private static Map<String, String> readAttributes(Element element) {
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap xmlAttrs = element.getAttributes();
        for (int i = 0; i < xmlAttrs.getLength(); ++i) {
            Attr item = (Attr)xmlAttrs.item(i);
            if (RESERVED_ATTRIBUTE_NAMES.contains(item.getName())) continue;
            map.put(item.getName(), item.getValue());
        }
        return map;
    }
}

