package com.xebialabs.xlplatform.synthetic;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;

/**
 * Encapsulates prefix and name of a {@link Type}.
 * Record style class with no spooky entanglements with registries and stuff.
 */
public final class TypeName {

    private final String prefix;
    private final String name;

    public TypeName(String typeName) {
        // Copied from com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.lookupType(java.lang.String)
        if (typeName.indexOf('.') == -1) {
            throw new IllegalArgumentException(String.format("Type %s does not contain a prefix", typeName));
        }
        int lastDot = typeName.lastIndexOf('.');
        prefix = typeName.substring(0, lastDot);
        name = typeName.substring(lastDot + 1);
    }

    public TypeName(String prefix, String name) {
        if (prefix == null || name == null) {
            throw new IllegalArgumentException("Either prefix or name is null, type should be fully qualified.");
        }
        this.prefix = prefix;
        this.name = name;
    }

    /**
     * @return The CI namespace for this type.
     */
    public String getPrefix() {
        return prefix;
    }

    /**
     * @return The simple name for this type.
     */
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TypeName type1 = (TypeName) o;

        return prefix.equals(type1.prefix) && name.equals(type1.name);
    }

    @Override
    public int hashCode() {
        int result = prefix != null ? prefix.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return prefix + "." + name;
    }

    public Type toType(IDescriptorRegistry registry) {
        return registry.lookupType(toString());
    }
}
