package com.xebialabs.deployit.booter.local.validation;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import org.apache.commons.lang.builder.HashCodeBuilder;

import java.util.Collection;
import java.util.Map;

public final class RequiredValidator implements Validator<Object> {

    @Override
    public void validate(Object value, ValidationContext context) {
        if (value == null
                || (value instanceof Collection && ((Collection<?>) value).isEmpty())
                || (value instanceof Map && ((Map<?, ?>) value).isEmpty())) {
            context.error("Value is required");
        }
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getClass().getName())
                .toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return other.getClass() == getClass();
    }
}
