package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.GeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;

class SyntheticLocalDescriptor extends LocalDescriptor {

    private GeneratedDeployableSpecification generatedDeployableSpec;

    SyntheticLocalDescriptor(Type registeredType, TypeSpecification typeSpec) {
        super(registeredType);
        initSynthetic(typeSpec);
        initHierarchy();
        resolveIcon();
    }

    private void initSynthetic(TypeSpecification typeSpec) {
        Type superType = typeSpec.getSuperType().toType(descriptorRegistry());
        addSuperClass(superType);
        setLabel(typeSpec.getLabel().orElse(toLabel(getType())));
        setDescription(typeSpec.getDescription().orElse("Description unavailable"));
        setVirtual(typeSpec.getVirtual().orElse(false));
        setVersioned(typeSpec.getVersioned().orElse(superType.getDescriptor().isVersioned()));
        setInspectable(typeSpec.getInspectable().orElse(false));
        typeSpec.getIcon().ifPresent(icon -> {
            this.setIcon(icon);
            this.setOwnIcon(true);
        });
        setRootName(typeSpec.getRoot());
        typeSpec.getContainerType().ifPresent(type -> setContainerType(type.toType(descriptorRegistry())));
        typeSpec.getDeployedType().ifPresent(type -> setDeployableType(type.toType(descriptorRegistry())));
        validators.addAll(createValidators(typeSpec.getValidationRules(), getType()));
        verifications.addAll(createVerifications(typeSpec.getVerifications(), getType()));
        typeSpec.getControlTasks().forEach(this::validateAndAddControlTask);
        typeSpec.getCreator().ifPresent(spec -> setCreator(LocalCreatorDescriptor.from(this, spec.getDelegate(), spec.getAttributes())));
        getPropertyDescriptors(typeSpec.getProperties()).forEach(this::overrideOrAddPropertyDescriptor);
        generatedDeployableSpec = typeSpec.getGeneratedDeployableDescription();
    }

    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        return generatedDeployableSpec;
    }

}
