package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DescriptorHierarchyInitializer {
    public static void init() {
        buildHierachicalTree();
    }

    static void buildHierachicalTree() {
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            logger.debug("Building hierarchy for {}", descriptor);
            ((LocalDescriptor) descriptor).initHierarchy();
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(DescriptorHierarchyInitializer.class);
}
