package com.xebialabs.deployit.booter.local;

import com.google.common.collect.Iterators;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.*;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

public class PluginVersions {

    private static final Map<String, String> PLUGIN_VERSIONS = newHashMap();

    static void init() {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("plugin-version.properties");
            ArrayList<URL> urls = newArrayList(Iterators.forEnumeration(resources));
            for (URL url : urls) {
                readPluginVersion(Resources.newInputStreamSupplier(url));
            }
        } catch (IOException e) {
            logger.error("Couldn't read plugin-version.properties", e);
            throw new IllegalStateException(e);
        }
    }

    public static String getVersionFor(String plugin) {
        return PLUGIN_VERSIONS.get(plugin);
    }

    public static Set<String> getRegisteredPlugins() {
        return PLUGIN_VERSIONS.keySet();
    }

    private static void readPluginVersion(InputSupplier<InputStream> supplier) throws IOException {
        InputStream input = supplier.getInput();
        try {
            Properties properties = new Properties();
            properties.load(input);
            String plugin = properties.getProperty("plugin");
            String version = properties.getProperty("version");
            PLUGIN_VERSIONS.put(plugin, version);
        } finally {
            Closeables.closeQuietly(input);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(PluginVersions.class);
}
