package com.xebialabs.deployit.booter.local;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import nl.javadude.scannit.Scannit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;

import static com.google.common.collect.FluentIterable.from;

class TypeInitializer {
    public static void init() {
        scanClasses();
    }

    static void scanClasses() {
        Set<Class<? extends ConfigurationItem>> cis = Scannit.getInstance().getSubTypesOf(ConfigurationItem.class);
        for (Class<? extends ConfigurationItem> ci : cis) {
            LocalDescriptorRegistry.register(ci);
        }
    }

    static void verifyTypes(Verifications verifications) {
        for (Descriptor descriptor : from(DescriptorRegistry.getDescriptors()).filter(new Predicate<Descriptor>() {
            @Override
            public boolean apply(Descriptor input) {
                return !input.isVirtual();
            }
        })) {
            ((LocalDescriptor) descriptor).verify(verifications);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(TypeInitializer.class);
}
