/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.GlobalContextInitializer;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.booter.local.TypeSystemBootstrapper;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBooter {
    private static final AtomicBoolean isBooted = new AtomicBoolean(false);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Logger logger = LoggerFactory.getLogger(LocalBooter.class);

    public static void boot() {
        try {
            LocalBooter.boot(true);
        }
        catch (RuntimeException re) {
            logger.error("Quitting, could not boot plugins: ", (Throwable)re);
            throw re;
        }
    }

    public static void bootWithoutGlobalContext() {
        LocalBooter.boot(false);
    }

    private static synchronized void boot(boolean withGlobalContext) {
        if (!isBooted.getAndSet(true)) {
            DescriptorRegistry.add((DescriptorRegistry)new LocalDescriptorRegistry());
            Scannit.boot((Configuration)Configuration.config().scan("com.xebialabs").scan("ext.deployit").with(new AbstractScanner[]{new TypeAnnotationScanner(), new MethodAnnotationScanner(), new SubTypeScanner()}));
            DelegateRegistry.boot();
            TypeSystemBootstrapper.bootstrap();
            Verifications verifications = new Verifications();
            DelegateRegistry.verify(verifications);
            TypeSystemBootstrapper.verifyTypes(verifications);
            verifications.done();
            if (withGlobalContext) {
                GlobalContextInitializer.init();
            }
            PluginVersions.init();
            initialized.set(true);
        }
        if (!initialized.get()) {
            throw new IllegalStateException("The DescriptorRegistry has been booted, but is not initialized. Please check the logs for any errors.");
        }
    }
}

