/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]s!B\n\u0015\u0011\u0003yb!B\u0011\u0015\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003bB\u0016\u0002\u0005\u0004%\t\u0001\f\u0005\u0007k\u0005\u0001\u000b\u0011B\u0017\t\u000bY\nA\u0011A\u001c\t\u000f\u0005\u0005\u0013\u0001\"\u0001\u0002D\u0019!\u0011\u0005\u0006\u0001:\u0011!QtA!A!\u0002\u0013Y\u0004\"B\u0015\b\t\u0003I\u0005BB&\bA\u0013%A\n\u0003\u0004Z\u000f\u0011\u0005AC\u0017\u0005\u0006E\u001e!\ta\u0019\u0005\u0007e\u001e\u0001K\u0011B:\t\u000f\u0005\u001dq\u0001\"\u0001\u0002\n!9\u00111C\u0004\u0005\u0002\u0005U\u0001\"CA\u0010\u000fE\u0005I\u0011AA\u0011\u0011\u001d\t\u0019b\u0002C\u0001\u0003oA\u0001\"a\u000f\bA\u0013%\u0011QH\u0001\u0010'R\u0014X-Y7fe\u001a\u000b7\r^8ss*\u0011QCF\u0001\u0003S>T!a\u0006\r\u0002\u0011A\f7m[1hKJT!!\u0007\u000e\u0002\u0011adG-\u001a9m_fT!a\u0007\u000f\u0002\u0013a,'-[1mC\n\u001c(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\u000b\u0003\u001fM#(/Z1nKJ4\u0015m\u0019;pef\u001c\"!A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq$\u0001\u0004m_\u001e<WM]\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006g24GG\u001b\u0006\u0002e\u0005\u0019qN]4\n\u0005Qz#A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001f\u0011,g-Y;mi6\u000b\u0007\u000f]5oON$\u0012\u0001\u000f\t\u0003A\u001d\u0019\"aB\u0012\u0002\u001f\u0005\u00148\r[5wK6\u000b\u0007\u000f]5oON\u0004B\u0001P\"G\r:\u0011Q(\u0011\t\u0003}\u0015j\u0011a\u0010\u0006\u0003\u0001z\ta\u0001\u0010:p_Rt\u0014B\u0001\"&\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0004\u001b\u0006\u0004(B\u0001\"&!\tat)\u0003\u0002I\u000b\n11\u000b\u001e:j]\u001e$\"\u0001\u000f&\t\u000biJ\u0001\u0019A\u001e\u0002/\u001d,G/\u0011:dQ&4X-\u00128uef\u001cFO]3b[\u0016\u0014HCA'Q!\t\u0001c*\u0003\u0002P)\tA1\u000b\u001e:fC6,'\u000fC\u0003R\u0015\u0001\u0007!+\u0001\u0003gS2,\u0007CA*X\u001b\u0005!&BA\u000bV\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001\u0017+\u0003\t\u0019KG.Z\u0001\u001eO\u0016$\u0018I]2iSZ,WI\u001c;ssN#(/Z1n'R\u0014X-Y7feR\u0019Qj\u00171\t\u000bq[\u0001\u0019A/\u0002\u0005%\u001c\bCA*_\u0013\tyFKA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"B1\f\u0001\u00041\u0015\u0001\u00028b[\u0016\facZ3u\u0003J\u001c\u0007.\u001b<f\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u000b\u0003IB\u0004\"!\u001a8\u000e\u0003\u0019T!a\u001a5\u0002\u0013\u0005\u00148\r[5wKJ\u001c(BA5k\u0003!\u0019w.\u001c9sKN\u001c(BA6m\u0003\u001d\u0019w.\\7p]NT!!\\\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tygMA\nBe\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003r\u0019\u0001\u0007!+\u0001\u0004uCJ<W\r^\u0001\u001aO\u0016$H+\u0019:Be\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000eF\u0002uun\u0004\"!\u001e=\u000e\u0003YT!a\u001e4\u0002\u0007Q\f'/\u0003\u0002zm\n1B+\u0019:Be\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003r\u001b\u0001\u0007!\u000bC\u0003}\u001b\u0001\u0007Q0\u0001\u0006d_6\u0004(/Z:t_J\u0004b\u0001\n@\u0002\u0002\u0005\u0005\u0011BA@&\u0005%1UO\\2uS>t\u0017\u0007E\u0002T\u0003\u0007I1!!\u0002U\u00051yU\u000f\u001e9viN#(/Z1n\u0003MA\u0017m]!sG\"Lg/Z#yi\u0016t7/[8o)\u0011\tY!!\u0005\u0011\u0007\u0011\ni!C\u0002\u0002\u0010\u0015\u0012qAQ8pY\u0016\fg\u000eC\u0003b\u001d\u0001\u0007a)\u0001\u0005tiJ,\u0017-\\3s)\u001di\u0015qCA\r\u00037AQ\u0001X\bA\u0002uCQ!Y\bA\u0002\u0019C\u0011\"!\b\u0010!\u0003\u0005\r!a\u0003\u0002\u0013%\u001c\u0018I]2iSZ,\u0017AE:ue\u0016\fW.\u001a:%I\u00164\u0017-\u001e7uIM*\"!a\t+\t\u0005-\u0011QE\u0016\u0003\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011G\u0013\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00026\u0005-\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR\u0019Q*!\u000f\t\u000bE\u000b\u0002\u0019\u0001*\u0002\u001d\u001d,G/\u0011:dQ&4X\rV=qKR\u0019a)a\u0010\t\u000b\u0005\u0014\u0002\u0019\u0001$\u0002\u0013\u0019|'oQ8oM&<Gc\u0001\u001d\u0002F!9\u0011q\t\u0004A\u0002\u0005%\u0013AB2p]\u001aLw\r\u0005\u0003\u0002L\u0005MSBAA'\u0015\u0011\t9%a\u0014\u000b\u0007\u0005EC$\u0001\u0005usB,7/\u00194f\u0013\u0011\t)&!\u0014\u0003\r\r{gNZ5h\u0001")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    public static Logger logger() {
        return StreamerFactory$.MODULE$.logger();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipFileArchiveStreamer(file);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarFileArchiveStreamer(file);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipArchiveStreamStreamer(resettableIs);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarArchiveStreamStreamer(resettableIs);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public ArchiveOutputStream getArchiveOutputStream(File target) {
        ZipArchiveOutputStream zipArchiveOutputStream;
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(target);
        } else {
            String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                zipArchiveOutputStream = new ZipArchiveOutputStream(target);
            } else {
                String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> os);
                } else {
                    String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new GzipCompressorOutputStream(os));
                    } else {
                        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new BZip2CompressorOutputStream(os));
                        } else {
                            String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
                            throw new UnsupportedArchiveExtensionException(new StringBuilder(59).append(target.getName()).append(" with extension ").append(originExt).append(" -> ").append(string).append(" is not a supported archive output type").toString());
                        }
                    }
                }
            }
        }
        return zipArchiveOutputStream;
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
    }

    public Streamer streamer(InputStream is, String name, boolean isArchive) {
        return this.hasArchiveExtension(name) ? this.getArchiveEntryStreamStreamer(is, name) : (isArchive ? new ZipArchiveStreamStreamer(ArtifactIOUtils$.MODULE$.getResettableInputStream(is)) : new FileStreamStreamer(is, name));
    }

    public Streamer streamer(File file) {
        return file.isDirectory() ? new DirectoryStreamer(file) : (this.hasArchiveExtension(file.getName()) ? this.getArchiveEntryStreamer(file) : new FileStreamer(file));
    }

    public boolean streamer$default$3() {
        return false;
    }

    private String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(new StringBuilder(27).append(name).append(" is not a supported archive").toString());
        }
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            throw new MatchError((Object)option);
        }
        String originExt = (String)tuple2._1();
        String mappedExt = (String)tuple2._2();
        StreamerFactory$.MODULE$.logger().debug(new StringBuilder(43).append("Detected mapped archive extension ").append(originExt).append(" -> ").append(mappedExt).append(" for ").append(name).toString());
        String string = mappedExt;
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString());
    }

    public StreamerFactory(Map<String, String> archiveMappings) {
        this.archiveMappings = archiveMappings;
    }
}

