/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.packager.truezip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;

public class TFiles {

    public static InputSupplier<InputStream> newInputSupplier(final TFile file) {
        return new InputSupplier<InputStream>() {
            @Override
            public InputStream getInput() throws IOException {
                return new TFileInputStream(file);
            }
        };
    }

    public static OutputSupplier<OutputStream> newOutputSupplier(final TFile file) {
        return new OutputSupplier<OutputStream>() {
            @Override
            public OutputStream getOutput() throws IOException {
                return new TFileOutputStream(file);
            }
        };
    }
}
