/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.packager;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.xld.Distribution;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CiNameCache {
    private Map<String, String> idNameCache = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(CiNameCache.class);

    void scan(DistributionVersion version) {
        Distribution application = version.getDistribution();
        this.idNameCache.put(application.getId(), application.getName());
        this.idNameCache.put(version.getId(), version.getName());
        this.scan((ConfigurationItem)version, null);
    }

    private void scan(ConfigurationItem configurationItem, String base) {
        for (PropertyDescriptor propertyDescriptor : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
            if (!EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(propertyDescriptor.getKind()) || !propertyDescriptor.isAsContainment()) continue;
            Collection cis = (Collection)propertyDescriptor.get(configurationItem);
            if (cis == null) {
                logger.warn("{}: {}.{} (as-containment, kind {}) should not be null", new Object[]{configurationItem.getId(), configurationItem.getType(), propertyDescriptor.getName(), propertyDescriptor.getKind()});
                continue;
            }
            for (ConfigurationItem ci : cis) {
                String id = CiNameCache.id(base, ci);
                this.idNameCache.put(ci.getId(), id);
                this.scan(ci, id);
            }
        }
    }

    String lookup(ConfigurationItem ci) {
        if (this.idNameCache.containsKey(ci.getId())) {
            return this.idNameCache.get(ci.getId());
        }
        return ci.getId();
    }

    private static String id(String baseId, ConfigurationItem ci) {
        String name = ci.getName();
        return CiNameCache.id(baseId, name);
    }

    static String id(String baseId, String name) {
        return Joiner.on((String)"/").skipNulls().join((Object)baseId, (Object)name, new Object[0]);
    }
}

