/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.packager.truezip

import java.util

import com.typesafe.config.ConfigFactory
import com.xebialabs.xldeploy.packager.PackagerConfig
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException
import de.schlichtherle.truezip.fs.archive.tar.{TarBZip2Driver, TarDriver, TarGZipDriver}
import de.schlichtherle.truezip.fs.archive.zip.{JarDriver, ZipDriver}
import de.schlichtherle.truezip.fs.spi.FsDriverService
import de.schlichtherle.truezip.fs.spi.FsDriverService._
import de.schlichtherle.truezip.fs.{FsDriver, FsScheme}
import de.schlichtherle.truezip.socket.sl.IOPoolLocator

class ArchiveExtensionDriverService(mappings: Map[String, String]) extends FsDriverService {

  def this() = this(new PackagerConfig(ConfigFactory.load(ConfigFactory.defaultReference())).archiveExtensionMappings)

  lazy private val drivers = newMap(
    mappings.
      groupBy(_._2).
      mapValues(_.keys).
      map { case (k,v) =>
        Array(v.mkString("|"), getArchiveDriver(k))
      }.toArray
  )

  private def getArchiveDriver(extension: String): FsDriver = {
    extension match {
      case "zip" => new ZipDriver(IOPoolLocator.SINGLETON)
      case "jar" => new JarDriver(IOPoolLocator.SINGLETON)
      case "tar" => new TarDriver(IOPoolLocator.SINGLETON)
      case "tar.gz" => new TarGZipDriver(IOPoolLocator.SINGLETON)
      case "tar.bz2" => new TarBZip2Driver(IOPoolLocator.SINGLETON)
      case _ => throw UnsupportedArchiveExtensionException(s"Unsupported archive extension registered $extension")
    }
  }

  override def get(): util.Map[FsScheme, FsDriver] = drivers

}
