/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.placeholders;

import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.util.BOM;
import com.xebialabs.deployit.util.DetectBOM$;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xldeploy.packager.MustacheScanningReader;
import com.xebialabs.xldeploy.packager.Mustacher;
import com.xebialabs.xldeploy.packager.Mustacher$;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.StreamEntry;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DigestOnly$;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessArchive$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessTextFile$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessingType;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner$;
import com.xebialabs.xldeploy.packager.placeholders.StreamFile;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u00055s!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\u0002\u0003\u0016\u0002\u0005\u0004%\t!A\u0016\t\rQ\n\u0001\u0015!\u0003-\u0011!)\u0014A1A\u0005\u0002\u00051\u0004BB\u001f\u0002A\u0003%q\u0007\u0003\u0005?\u0003\t\u0007I\u0011A\u0001@\u0011\u00199\u0015\u0001)A\u0005\u0001\u001a!\u0001e\u0005\u0001I\u0011!I\u0015B!A!\u0002\u0013Q\u0005\"\u0002\u0015\n\t\u0003i\u0005\"\u0002)\n\t\u0003\t\u0006BB7\nA\u0013%a\u000e\u0003\u0005\u0002\u0002%\u0001K\u0011BA\u0002\u0011!\t9\"\u0003Q\u0005\n\u0005e\u0001\u0002CA\u0012\u0013\u0001&I!!\n\t\u0011\u0005M\u0012\u0002)C\u0005\u0003k\tQcU8ve\u000e,\u0017I\u001d;jM\u0006\u001cGoU2b]:,'O\u0003\u0002\u0015+\u0005a\u0001\u000f\\1dK\"|G\u000eZ3sg*\u0011acF\u0001\ta\u0006\u001c7.Y4fe*\u0011\u0001$G\u0001\tq2$W\r\u001d7ps*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001\u0001\t\u0003?\u0005i\u0011a\u0005\u0002\u0016'>,(oY3BeRLg-Y2u'\u000e\fgN\\3s'\t\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\ta\u0001\\8hO\u0016\u0014X#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:mMRR'\"A\u0019\u0002\u0007=\u0014x-\u0003\u00024]\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0004eKZtU\u000f\u001c7\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u000b\u0002\u0005%|\u0017B\u0001\u001f:\u0005\u001d!UM\u001e(vY2\f\u0001\u0002Z3w\u001dVdG\u000eI\u0001\u000eI\u00164h*\u001e7m/JLG/\u001a:\u0016\u0003\u0001\u0003\"!Q#\u000e\u0003\tS!AO\"\u000b\u0003\u0011\u000bAA[1wC&\u0011aI\u0011\u0002\u0013\u001fV$\b/\u001e;TiJ,\u0017-\\,sSR,'/\u0001\beKZtU\u000f\u001c7Xe&$XM\u001d\u0011\u0014\u0005%\u0011\u0013aD:ue\u0016\fW.\u001a:GC\u000e$xN]=\u0011\u0005aZ\u0015B\u0001':\u0005=\u0019FO]3b[\u0016\u0014h)Y2u_JLHC\u0001(P!\ty\u0012\u0002C\u0003J\u0017\u0001\u0007!*\u0001\bf]JL7\r[!si&4\u0017m\u0019;\u0015\u0007I+V\r\u0005\u0002$'&\u0011A\u000b\n\u0002\u0005+:LG\u000fC\u0003W\u0019\u0001\u0007q+\u0001\u0002tCB\u0011\u0001lY\u0007\u00023*\u0011!lW\u0001\tCJ$\u0018NZ1di*\u0011A,X\u0001\u0004k\u0012l'B\u00010`\u0003\r\t\u0007/\u001b\u0006\u0003A\u0006\fa\u0001\u001d7vO&t'B\u00012\u001a\u0003!!W\r\u001d7ps&$\u0018B\u00013Z\u00059\u0019v.\u001e:dK\u0006\u0013H/\u001b4bGRDQA\u001a\u0007A\u0002\u001d\f!b\u001d;sK\u0006lg)\u001b7f!\r\u0019\u0003N[\u0005\u0003S\u0012\u0012aa\u00149uS>t\u0007CA\u0010l\u0013\ta7C\u0001\u0006TiJ,\u0017-\u001c$jY\u0016\fadY1mGVd\u0017\r^3QY\u0006\u001cW\r[8mI\u0016\u00148/\u00118e\t&<Wm\u001d;\u0015\u000bI{\u0007/]<\t\u000bYk\u0001\u0019A,\t\u000b\u0019l\u0001\u0019A4\t\u000bIl\u0001\u0019A:\u0002\u00135,8\u000f^1dQ\u0016\u0014\bC\u0001;v\u001b\u0005)\u0012B\u0001<\u0016\u0005%iUo\u001d;bG\",'\u000fC\u0003y\u001b\u0001\u0007\u00110A\u0005paR$\u0015nZ3tiB\u00191\u0005\u001b>\u0011\u0005mtX\"\u0001?\u000b\u0005u\u001c\u0015\u0001C:fGV\u0014\u0018\u000e^=\n\u0005}d(!D'fgN\fw-\u001a#jO\u0016\u001cH/\u0001\ntG\u0006tgi\u001c7eKJ\f%\u000f^5gC\u000e$H#\u0003*\u0002\u0006\u0005=\u0011\u0011CA\u000b\u0011\u001d\t9A\u0004a\u0001\u0003\u0013\t!AZ1\u0011\u0007a\u000bY!C\u0002\u0002\u000ee\u0013aBR8mI\u0016\u0014\u0018I\u001d;jM\u0006\u001cG\u000fC\u0003g\u001d\u0001\u0007q\r\u0003\u0004\u0002\u00149\u0001\r!_\u0001\u0007I&<Wm\u001d;\t\u000bIt\u0001\u0019A:\u00023M\u001c\u0017M\u001c$jY\u0016|%/\u0011:dQ&4X-\u0011:uS\u001a\f7\r\u001e\u000b\n%\u0006m\u0011QDA\u0010\u0003CAQAV\bA\u0002]CQAZ\bA\u0002)Da!a\u0005\u0010\u0001\u0004I\b\"\u0002:\u0010\u0001\u0004\u0019\u0018\u0001G;qI\u0006$X\rR5hKN$x+\u001b;i\r&dWM\\1nKR)!+a\n\u00022!9\u0011\u0011\u0006\tA\u0002\u0005-\u0012!B3oiJL\bc\u0001\u001d\u0002.%\u0019\u0011qF\u001d\u0003\u0017M#(/Z1n\u000b:$(/\u001f\u0005\u0007\u0003'\u0001\u0002\u0019\u0001>\u0002\r\u0011|7kY1o)%\u0011\u0016qGA\u001d\u0003w\ti\u0004C\u0003W#\u0001\u0007q\u000bC\u0004\u0002*E\u0001\r!a\u000b\t\u000bI\f\u0002\u0019A:\t\u000f\u0005}\u0012\u00031\u0001\u0002B\u0005IAO]1og\u001a|'/\u001c\t\bG\u0005\r\u0013qIA$\u0013\r\t)\u0005\n\u0002\n\rVt7\r^5p]F\u00022!QA%\u0013\r\tYE\u0011\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e")
public class SourceArtifactScanner {
    private final StreamerFactory streamerFactory;

    public void enrichArtifact(SourceArtifact sa, Option<StreamFile> streamFile) {
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders() && PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum()) {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(75).append("Not enriching ").append(sa).append(" as no placeholders should be scanned and checksum is present").toString());
            return;
        }
        None$ digest = !PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum() ? new Some((Object)MessageDigest.getInstance("SHA1")) : None$.MODULE$;
        Mustacher mustacher = Mustacher$.MODULE$.apply(PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).mustacheDelimiters());
        this.calculatePlaceholdersAndDigest(sa, streamFile, mustacher, (Option<MessageDigest>)digest);
        sa.setPlaceholders((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(mustacher.placeholders()).asJava());
        digest.foreach((Function1 & Serializable & scala.Serializable)d -> {
            sa.setProperty("checksum", (Object)Hex.encodeHexString((byte[])d.digest()));
            return BoxedUnit.UNIT;
        });
    }

    private void calculatePlaceholdersAndDigest(SourceArtifact sa, Option<StreamFile> streamFile, Mustacher mustacher, Option<MessageDigest> optDigest) {
        SourceArtifact sourceArtifact = sa;
        if (sourceArtifact instanceof FolderArtifact) {
            FolderArtifact folderArtifact = (FolderArtifact)sourceArtifact;
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(44).append("Going to scan artifact ").append(folderArtifact).append(" as a folder artifact").toString());
            this.scanFolderArtifact(folderArtifact, streamFile, optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamFile.isEmpty()) {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(23).append("Going to scan artifact ").append(sa).toString());
            TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sa.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)fis -> {
                this.scanFileOrArchiveArtifact(sa, new StreamFile(sa.getFile().getName(), fis), (Option<MessageDigest>)optDigest, mustacher);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(35).append("Going to scan artifact ").append(sa).append(" from stream").toString());
            this.scanFileOrArchiveArtifact(sa, (StreamFile)streamFile.get(), optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void scanFolderArtifact(FolderArtifact fa, Option<StreamFile> streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        Streamer streamer;
        Option<StreamFile> option = streamFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            StreamFile x = (StreamFile)some.value();
            streamer = this.streamerFactory.streamer(x.inputStream(), x.name());
        } else if (None$.MODULE$.equals(option)) {
            streamer = this.streamerFactory.streamer(PlaceholdersUtil$.MODULE$.SourceArtifactUtil((SourceArtifact)fa).toLocalFile());
        } else {
            throw new MatchError(option);
        }
        Streamer streamer2 = streamer;
        streamer2.stream().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            SourceArtifactScanner.$anonfun$scanFolderArtifact$1(this, digest, fa, mustacher, entry);
            return BoxedUnit.UNIT;
        });
    }

    private void scanFileOrArchiveArtifact(SourceArtifact sa, StreamFile streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        InputStream inputStream = (InputStream)digest.map((Function1 & Serializable & scala.Serializable)x$2 -> new DigestInputStream(streamFile.inputStream(), (MessageDigest)x$2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> streamFile.inputStream());
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders()) {
            SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(45).append("Artifact [").append(sa).append("] has disabled placeholder scanning").toString());
        } else {
            this.streamerFactory.streamer(inputStream, streamFile.name()).stream().foreach((Function1 & Serializable & scala.Serializable)entry -> {
                this.doScan(sa, entry, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                return BoxedUnit.UNIT;
            });
        }
        OverthereUtils.write((InputStream)inputStream, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
    }

    private void updateDigestWithFilename(StreamEntry entry, MessageDigest digest) {
        String digestPath = new StringBuilder(0).append(entry.getPath()).append((Object)(entry.isDirectory() ? File.separator : "")).toString();
        digestPath = digestPath.replace("\\", "/");
        SourceArtifactScanner$.MODULE$.logger().trace(new StringBuilder(46).append("scanFolderArtifact: update digest with path [").append(digestPath).append("]").toString());
        digest.update(digestPath.getBytes(StandardCharsets.UTF_8));
    }

    private void doScan(SourceArtifact sa, StreamEntry entry, Mustacher mustacher, Function1<InputStream, InputStream> transform) {
        if (entry.isDirectory()) {
            return;
        }
        TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> entry.getInputStream(), (Function1 & Serializable & scala.Serializable)inputStream -> {
            Try try_;
            InputStream is = (InputStream)transform.apply(inputStream);
            StreamerFactory sf = $this.streamerFactory;
            ProcessingType processingType = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).getScanTypeForEntry(entry, sf);
            if (DigestOnly$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(11).append(sa).append(": Skipping ").append(entry.getName()).toString());
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessArchive$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(23).append(sa).append(": Detected archive for ").append(entry.getName()).toString());
                $this.streamerFactory.streamer(is, entry.getName()).stream().foreach((Function1 & Serializable & scala.Serializable)e2 -> {
                    this.doScan(sa, e2, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                    return BoxedUnit.UNIT;
                });
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessTextFile$.MODULE$.equals(processingType)) {
                InputStreamReader inputStreamReader;
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(18).append(sa).append(": ").append(entry.getName()).append(" is a text file.").toString());
                InputStream resettableInputStream = ArtifactIOUtils$.MODULE$.getResettableInputStream(is);
                BOM bOM = DetectBOM$.MODULE$.detect(resettableInputStream);
                if (((Object)((Object)BOM.NONE)).equals((Object)bOM)) {
                    inputStreamReader = new InputStreamReader(resettableInputStream);
                } else if (bOM != null) {
                    BOM bOM2 = bOM;
                    inputStreamReader = new InputStreamReader(resettableInputStream, bOM2.getCharset());
                } else {
                    throw new MatchError((Object)bOM);
                }
                InputStreamReader reader = inputStreamReader;
                try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> mustacher.newReader(reader), (Function1 & Serializable & scala.Serializable)r -> {
                    SourceArtifactScanner.$anonfun$doScan$6(r);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)processingType);
            }
            return try_;
        });
    }

    public static final /* synthetic */ void $anonfun$scanFolderArtifact$1(SourceArtifactScanner $this, Option digest$1, FolderArtifact fa$1, Mustacher mustacher$2, StreamEntry entry) {
        digest$1.foreach((Function1 & Serializable & scala.Serializable)d -> {
            $this.updateDigestWithFilename(entry, d);
            return BoxedUnit.UNIT;
        });
        $this.doScan((SourceArtifact)fa$1, entry, mustacher$2, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> (InputStream)digest$1.map((Function1 & Serializable & scala.Serializable)x$1 -> new DigestInputStream((InputStream)is, (MessageDigest)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> is));
    }

    public static final /* synthetic */ void $anonfun$doScan$6(MustacheScanningReader r) {
        OverthereUtils.write((Reader)r, (Writer)SourceArtifactScanner$.MODULE$.devNullWriter());
    }

    public SourceArtifactScanner(StreamerFactory streamerFactory) {
        this.streamerFactory = streamerFactory;
    }
}

