/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xldeploy.packager


import com.typesafe.config.{Config, ConfigUtil}
import com.xebialabs.xldeploy.packager.PackagerConfig.configPrefix

import scala.jdk.CollectionConverters._

object PackagerConfig {
  private val configPrefix = "xl.artifact.placeholders"
}

class PackagerConfig(config: Config) {

  private val packagerConfig = config.getConfig(configPrefix)

  val archiveExtensionMappings: Map[String, String] =
    packagerConfig.getConfig("archive-extensions")
      .entrySet()
      .asScala
      .foldLeft(Map[String, String]()) {
        case (m, e) =>
          val key = ConfigUtil.splitPath(e.getKey).get(0)
          val value = e.getValue.unwrapped().toString
          if (key == "tar" && value != "tar") {
            m + (key -> "tar")
          } else {
            m + (key -> value)
          }
      }

  val zipEncoding = packagerConfig.getString("zip-encoding")
  val jarEncoding = packagerConfig.getString("jar-encoding")
}
