/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xldeploy.packager.placeholders

import java.io.{File, InputStream}
import java.security.MessageDigest

import com.xebialabs.deployit.io.LocalFileBased
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact.SCAN_PLACEHOLDERS_PROPERTY_NAME
import com.xebialabs.overthere.local.LocalFile
import com.xebialabs.xldeploy.packager.io.{StreamEntry, StreamerFactory}

object PlaceholdersUtil {

  implicit class SourceArtifactUtil(sa: SourceArtifact) {

    val defaultDelims = "{{ }}"

    def mustacheDelimiters(): String = if (sa.hasProperty("delimiters")) {
      sa.getProperty[String]("delimiters")
    } else {
      defaultDelims
    }

    def shouldScanPlaceholders(): Boolean = {
      !sa.hasProperty(SCAN_PLACEHOLDERS_PROPERTY_NAME) || sa.getProperty[Boolean](SCAN_PLACEHOLDERS_PROPERTY_NAME)
    }

    def hasCheckSum: Boolean = {
      sa.getChecksum != null && !sa.getChecksum.isEmpty
    }

    def shouldGenerateChecksum(isRescan: Boolean): Boolean = {
      !sa.hasCheckSum || (sa.shouldScanPlaceholders() && isRescan)
    }

    def addChecksumAndScan(sas: SourceArtifactScanner, messageDigest: () => MessageDigest): Unit = {
      sas.enrichArtifact(sa, None, messageDigest)
    }

    def addChecksumAndScan(sas: SourceArtifactScanner, streamFileName: String, inputStream: InputStream,
                           messageDigest: () => MessageDigest): Unit = {
      sas.enrichArtifact(sa, Some(StreamFile(streamFileName, inputStream)), messageDigest)
    }

    def rescan(sas: SourceArtifactScanner, messageDigest: () => MessageDigest): Unit = {
      sas.scanAndCalculateDigest(sa, None, messageDigest, isRescan = true)
    }
    def rescan(sas: SourceArtifactScanner, messageDigest: () => MessageDigest,fileSize:Long): Unit = {
      sas.scanAndCalculateDigest(sa, None, messageDigest, isRescan = true,fileSize)
    }
    def rescan(sas: SourceArtifactScanner, streamFileName: String, inputStream: InputStream,
               messageDigest: () => MessageDigest): Unit = {
      sas.scanAndCalculateDigest(sa, Some(StreamFile(streamFileName, inputStream)), messageDigest, isRescan = true)
    }

    def rescan(sas: SourceArtifactScanner, streamFileName: String, inputStream: InputStream,
               messageDigest: () => MessageDigest,fileSize:Long): Unit = {
      sas.scanAndCalculateDigest(sa, Some(StreamFile(streamFileName, inputStream)), messageDigest, isRescan = true,fileSize)
    }

    def getScanTypeForEntry(entry: StreamEntry)(implicit streamerFactory: StreamerFactory): ProcessingType =
      new ScanSpec(sa).getProcessingType(entry)

    def toLocalFile: File = sa.getFile match {
      case l: LocalFile => l.getFile
      case s: LocalFileBased => s.getLocalFile
      case x => throw new RuntimeException(s"Source artifact ${sa.getName} is not local file based but ${x.getClass}")
    }

  }
}
